/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.dbupdates;

import com.tacitknowledge.util.migration.MigrationContext;
import com.tacitknowledge.util.migration.MigrationException;
import com.tacitknowledge.util.migration.MigrationTaskSupport;
import com.tacitknowledge.util.migration.jdbc.DataSourceMigrationContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Patch02030300
extends MigrationTaskSupport {
    private static Logger log = Logger.getLogger(Patch02030300.class);
    private static final Integer LEVEL = new Integer(2030300);
    private static final String NAME = "Fix3rdPartyUserRoles";

    public Patch02030300() {
        this.setLevel(LEVEL);
        this.setName(NAME);
    }

    public void migrate(MigrationContext context) throws MigrationException {
        DataSourceMigrationContext ctx = (DataSourceMigrationContext)context;
        Connection conn = null;
        try {
            conn = ctx.getConnection();
            conn.setAutoCommit(false);
            ArrayList<Integer> orgIds = new ArrayList<Integer>();
            String queryStr = "select distinct uo.organisation_id from lams_user_organisation uo, lams_ext_user_userid_map eu where eu.user_id=uo.user_id";
            PreparedStatement query = conn.prepareStatement(queryStr);
            if (query.execute()) {
                ResultSet rs = query.getResultSet();
                while (rs.next()) {
                    orgIds.add(rs.getInt(1));
                }
            }
            for (Integer orgId : orgIds) {
                log.debug((Object)("Found 3rd party organisation with id " + orgId + "..."));
                ArrayList<Integer> staffIds = new ArrayList<Integer>();
                queryStr = "select distinct ug.user_id from lams_lesson l, lams_grouping gg, lams_group g, lams_user_group ug where l.class_grouping_id=gg.grouping_id and gg.staff_group_id=g.group_id and g.group_id=ug.group_id and l.organisation_id=?";
                query = conn.prepareStatement(queryStr);
                query.setInt(1, orgId);
                if (query.execute()) {
                    ResultSet rs = query.getResultSet();
                    while (rs.next()) {
                        staffIds.add(rs.getInt(1));
                    }
                }
                ArrayList<Integer> userIds = new ArrayList<Integer>();
                queryStr = "select distinct uo.user_id from lams_user_organisation uo, lams_ext_user_userid_map eu where uo.user_id=eu.user_id and uo.organisation_id=?";
                query = conn.prepareStatement(queryStr);
                query.setInt(1, orgId);
                if (query.execute()) {
                    ResultSet rs = query.getResultSet();
                    while (rs.next()) {
                        userIds.add(rs.getInt(1));
                    }
                }
                for (Integer userId : userIds) {
                    if (staffIds.contains(userId)) continue;
                    queryStr = "delete uor.* from lams_user_organisation_role uor, lams_user_organisation uo where uo.user_id=? and uo.user_organisation_id=uor.user_organisation_id and uo.organisation_id=? and uor.role_id!=5";
                    query = conn.prepareStatement(queryStr);
                    query.setInt(1, userId);
                    query.setInt(2, orgId);
                    int deleted = query.executeUpdate();
                    log.info((Object)("Deleted " + deleted + " non-learner roles for user id " + userId + " in org id " + orgId));
                }
            }
            ctx.commit();
        }
        catch (Exception e) {
            ctx.rollback();
            throw new MigrationException("Problem running update; ", (Throwable)e);
        }
    }
}

