/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.integration.security;

import java.util.Random;
import org.apache.commons.lang.ArrayUtils;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.ValidationUtil;

public class RandomPasswordGenerator {
    private static final char[] UPPER_CASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] LOWER_CASE = "abedefghijklmnopqrstuvwxyz".toCharArray();
    private static final char[] DIGITS = "0123456789".toCharArray();
    private static final char[] SYMBOLS = "`~!@#$%^&*\\()_-+={}[]|:;\"'<>,.?/".toCharArray();
    private static final char[] SIMPLE_PASSWORD_RANGE = ArrayUtils.addAll((char[])ArrayUtils.addAll((char[])UPPER_CASE, (char[])LOWER_CASE), (char[])DIGITS);
    private static final char NULL_CHAR = '\u0000';
    private static final int MINIMUM_PASSWORD_LENGTH = 10;

    public static String nextPassword(int length) {
        char[] res = new char[length];
        Random generator = new Random();
        for (int i = 0; i < length; ++i) {
            res[i] = SIMPLE_PASSWORD_RANGE[generator.nextInt(SIMPLE_PASSWORD_RANGE.length)];
        }
        return new String(res);
    }

    public static String nextPasswordValidated() {
        Random generator = new Random();
        int length = Math.max(10, Configuration.getAsInt(ConfigurationKeys.PASSWORD_POLICY_MINIMUM_CHARACTERS));
        char[] res = new char[length];
        int index = 0;
        for (char[] set : new char[][]{UPPER_CASE, LOWER_CASE, DIGITS, SYMBOLS}) {
            while (res[index = generator.nextInt(length)] != '\u0000') {
            }
            res[index] = set[generator.nextInt(set.length)];
        }
        for (index = 0; index < length; ++index) {
            if (res[index] != '\u0000') continue;
            res[index] = SIMPLE_PASSWORD_RANGE[generator.nextInt(SIMPLE_PASSWORD_RANGE.length)];
        }
        String result = String.valueOf(res);
        if (!ValidationUtil.isPasswordValueValid(result, result)) {
            throw new RuntimeException("Password generator created password which does not pass validation: " + result);
        }
        return result;
    }
}

