/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.dto;

import java.util.ArrayList;
import java.util.Date;
import org.lamsfoundation.lams.learningdesign.DataFlowObject;
import org.lamsfoundation.lams.learningdesign.DataTransition;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dto.BaseDTO;
import org.lamsfoundation.lams.learningdesign.dto.DataFlowObjectDTO;

public class TransitionDTO
extends BaseDTO {
    private Long transitionID;
    private Integer transitionUIID;
    private Integer toUIID;
    private Integer fromUIID;
    private String description;
    private String title;
    private Date createDateTime;
    private Long toActivityID;
    private Long fromActivityID;
    private Long learningDesignID;
    private Integer transitionType;
    private ArrayList<DataFlowObjectDTO> dataFlowObjects;

    public TransitionDTO() {
    }

    public TransitionDTO(Long transitionId, Integer transitionUIID, Integer toUIID, Integer fromUIID, String description, String title, Date createDateTime, Long toActivityID, Long fromActivityID, Long learningDesignID) {
        this.transitionID = transitionId;
        this.transitionUIID = transitionUIID;
        this.toUIID = toUIID;
        this.fromUIID = fromUIID;
        this.description = description;
        this.title = title;
        this.createDateTime = createDateTime;
        this.toActivityID = toActivityID;
        this.fromActivityID = fromActivityID;
        this.learningDesignID = learningDesignID;
        this.dataFlowObjects = new ArrayList();
    }

    public TransitionDTO(Transition transition) {
        this.transitionID = transition.getTransitionId();
        this.transitionUIID = transition.getTransitionUIID();
        this.toUIID = transition.getToUIID();
        this.fromUIID = transition.getFromUIID();
        this.description = transition.getDescription();
        this.title = transition.getTitle();
        this.createDateTime = transition.getCreateDateTime();
        this.toActivityID = transition.getToActivity().getActivityId();
        this.fromActivityID = transition.getFromActivity().getActivityId();
        this.learningDesignID = transition.getLearningDesign().getLearningDesignId();
        this.transitionType = transition.getTransitionType();
        this.dataFlowObjects = new ArrayList();
        if (transition.isDataTransition()) {
            DataTransition dataTransition = (DataTransition)transition;
            for (DataFlowObject dataFlowObject : dataTransition.getDataFlowObjects()) {
                DataFlowObjectDTO dataFlowObjectDto = new DataFlowObjectDTO(dataFlowObject);
                this.dataFlowObjects.add(dataFlowObjectDto);
            }
        }
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getFromActivityID() {
        return this.fromActivityID;
    }

    public Integer getFromUIID() {
        return this.fromUIID;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getToActivityID() {
        return this.toActivityID;
    }

    public Integer getToUIID() {
        return this.toUIID;
    }

    public Long getTransitionID() {
        return this.transitionID;
    }

    public Integer getTransitionUIID() {
        return this.transitionUIID;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFromActivityID(Long fromActivityID) {
        this.fromActivityID = fromActivityID;
    }

    public void setFromUIID(Integer fromUIID) {
        this.fromUIID = fromUIID;
    }

    public void setLearningDesignID(Long learningDesignID) {
        this.learningDesignID = learningDesignID;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setToActivityID(Long toActivityID) {
        this.toActivityID = toActivityID;
    }

    public void setToUIID(Integer toUIID) {
        this.toUIID = toUIID;
    }

    public void setTransitionID(Long transitionId) {
        this.transitionID = transitionId;
    }

    public void setTransitionUIID(Integer transitionUIID) {
        this.transitionUIID = transitionUIID;
    }

    public Integer getTransitionType() {
        return this.transitionType;
    }

    public void setTransitionType(Integer transitionType) {
        this.transitionType = transitionType;
    }

    public ArrayList<DataFlowObjectDTO> getDataFlowObjects() {
        return this.dataFlowObjects;
    }

    public void setDataFlowObjects(ArrayList<DataFlowObjectDTO> dataFlowObjects) {
        this.dataFlowObjects = dataFlowObjects;
    }
}

