/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ToolContentVersionFilter {
    private static final Logger log = Logger.getLogger(ToolContentVersionFilter.class);
    private List<RemovedField> removedFieldList = new ArrayList<RemovedField>();
    private List<AddedField> addedFieldList = new ArrayList<AddedField>();
    private List<RenamedField> renamedFieldList = new ArrayList<RenamedField>();

    public void removeField(Class ownerClass, String fieldname) {
        this.removedFieldList.add(new RemovedField(ownerClass, fieldname));
    }

    public void removeField(String ownerClass, String fieldname) {
        this.removedFieldList.add(new RemovedField(ownerClass, fieldname));
    }

    public void addField(Class ownerClass, String fieldname, String defaultValue) {
        this.addedFieldList.add(new AddedField(ownerClass, fieldname, defaultValue));
    }

    public void addField(String ownerClass, String fieldname, String defaultValue) {
        this.addedFieldList.add(new AddedField(ownerClass, fieldname, defaultValue));
    }

    public void renameField(Class ownerClass, String oldFieldname, String newFieldname) {
        this.renamedFieldList.add(new RenamedField(ownerClass, oldFieldname, newFieldname));
    }

    public void renameField(String ownerClass, String oldFieldname, String newFieldname) {
        this.renamedFieldList.add(new RenamedField(ownerClass, oldFieldname, newFieldname));
    }

    public void transformXML(String toolFilePath) throws IOException {
        File toolFile = new File(toolFilePath);
        try {
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.parse(new FileInputStream(toolFile));
            Element root = doc.getDocumentElement();
            this.retrieveXML(root);
            toolFile.renameTo(new File(toolFilePath + "_oldver"));
            File newToolFile = new File(toolFilePath);
            FileUtil.writeXMLtoFile(doc, newToolFile);
        }
        catch (Exception e) {
            throw new IOException("Error while transforming XML", e);
        }
    }

    private void retrieveXML(Element root) throws IOException {
        Node oldNode;
        Node node;
        for (RemovedField remove : this.removedFieldList) {
            if (!StringUtils.equals((String)root.getNodeName(), (String)remove.ownerClass) && !StringUtils.equals((String)root.getAttribute("class"), (String)remove.ownerClass)) continue;
            for (node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
                oldNode = node;
                if (!oldNode.getNodeName().equals(remove.fieldname)) continue;
                root.removeChild(oldNode);
                log.debug((Object)("Field " + remove.fieldname + " in class " + remove.ownerClass + " was removed."));
            }
        }
        for (AddedField added : this.addedFieldList) {
            if (!StringUtils.equals((String)root.getNodeName(), (String)added.ownerClass)) continue;
            Element element = root.getOwnerDocument().createElement(added.fieldname);
            element.setTextContent(added.defaultValue);
            root.appendChild(element);
            log.debug((Object)("Field " + added.fieldname + " in class " + added.ownerClass + " was added by value " + added.defaultValue));
        }
        for (RenamedField renamed : this.renamedFieldList) {
            if (!StringUtils.equals((String)root.getNodeName(), (String)renamed.ownerClass)) continue;
            node = root.getFirstChild();
            while (node != null) {
                oldNode = node;
                node = node.getNextSibling();
                if (!oldNode.getNodeName().equals(renamed.oldFieldname)) continue;
                Element newElement = root.getOwnerDocument().createElement(renamed.newFieldname);
                if (oldNode.hasChildNodes()) {
                    NodeList children = oldNode.getChildNodes();
                    for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                        newElement.appendChild(children.item(childIndex).cloneNode(true));
                    }
                } else {
                    newElement.setTextContent(oldNode.getTextContent());
                }
                root.replaceChild(newElement, oldNode);
                log.debug((Object)("Field " + renamed.oldFieldname + " in class " + renamed.ownerClass + " was renamed to " + renamed.newFieldname));
            }
        }
        NodeList children = root.getChildNodes();
        for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
            node = children.item(childIndex);
            if (node.getNodeType() != 1) continue;
            this.retrieveXML((Element)node);
        }
    }

    private class RenamedField {
        private String ownerClass;
        private String oldFieldname;
        private String newFieldname;

        private RenamedField(Class ownerClass, String oldFieldname, String newFieldname) {
            this.ownerClass = ownerClass.getName();
            this.oldFieldname = oldFieldname;
            this.newFieldname = newFieldname;
        }

        private RenamedField(String ownerClass, String oldFieldname, String newFieldname) {
            this.ownerClass = ownerClass;
            this.oldFieldname = oldFieldname;
            this.newFieldname = newFieldname;
        }
    }

    private class AddedField {
        private String ownerClass;
        private String fieldname;
        private String defaultValue;

        private AddedField(Class ownerClass, String fieldname, String defaultValue) {
            this.ownerClass = ownerClass.getName();
            this.fieldname = fieldname;
            this.defaultValue = defaultValue;
        }

        private AddedField(String ownerClass, String fieldname, String defaultValue) {
            this.ownerClass = ownerClass;
            this.fieldname = fieldname;
            this.defaultValue = defaultValue;
        }
    }

    private class RemovedField {
        private String ownerClass;
        private String fieldname;

        private RemovedField(Class ownerClass, String fieldname) {
            this.ownerClass = ownerClass.getName();
            this.fieldname = fieldname;
        }

        private RemovedField(String ownerClass, String fieldname) {
            this.ownerClass = ownerClass;
            this.fieldname = fieldname;
        }
    }
}

