/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dto;

import java.util.Date;
import org.lamsfoundation.lams.lesson.Lesson;

public class LessonDetailsDTO {
    private Long lessonID;
    private String lessonName;
    private String lessonDescription;
    private Integer lessonStateID;
    private Date createDateTime;
    private String createDateTimeStr;
    private Date startDateTime;
    private String startDateTimeStr;
    private Date scheduleStartDate;
    private String scheduleStartDateStr;
    private Date scheduleEndDate;
    private Long duration;
    private Integer organisationID;
    private String organisationName;
    private String organisationDescription;
    private Integer workspaceFolderID;
    private String contentFolderID;
    private Long licenseID;
    private String licenseText;
    private Long learningDesignID;
    private Integer numberPossibleLearners;
    private Integer numberStartedLearners;
    private Boolean locked_for_edit;
    private Boolean learnerPresenceAvailable;
    private Boolean learnerImAvailable;
    private Boolean liveEditEnabled;
    private Boolean isPreview;
    private String encodedLessonID;
    private Boolean enabledLessonNotifications;
    private Boolean enableLessonIntro;
    private Boolean gradebookOnComplete;

    public LessonDetailsDTO(Lesson lesson) {
        this.lessonID = lesson.getLessonId();
        this.lessonName = lesson.getLessonName();
        this.lessonDescription = lesson.getLessonDescription();
        this.lessonStateID = lesson.getLessonStateId();
        this.createDateTime = lesson.getCreateDateTime();
        this.createDateTimeStr = null;
        this.startDateTime = lesson.getStartDateTime();
        this.startDateTimeStr = null;
        this.scheduleStartDate = lesson.getScheduleStartDate();
        this.scheduleStartDateStr = null;
        this.scheduleEndDate = lesson.getScheduleEndDate();
        this.duration = lesson.getLearningDesign().getDuration();
        this.organisationID = lesson.getOrganisation() != null ? lesson.getOrganisation().getOrganisationId() : null;
        this.organisationName = lesson.getOrganisation() != null ? lesson.getOrganisation().getName() : null;
        this.organisationDescription = lesson.getOrganisation() != null ? lesson.getOrganisation().getDescription() : null;
        this.workspaceFolderID = lesson.getLearningDesign().getWorkspaceFolder() != null ? lesson.getLearningDesign().getWorkspaceFolder().getWorkspaceFolderId() : null;
        this.contentFolderID = lesson.getLearningDesign().getContentFolderID() != null ? lesson.getLearningDesign().getContentFolderID() : null;
        this.licenseID = lesson.getLearningDesign().getLicense() != null ? lesson.getLearningDesign().getLicense().getLicenseID() : null;
        this.licenseText = lesson.getLearningDesign().getLicenseText();
        this.learningDesignID = lesson.getLearningDesign().getLearningDesignId();
        this.numberPossibleLearners = lesson.getAllLearners().size();
        this.numberStartedLearners = 0;
        this.learnerPresenceAvailable = lesson.getLearnerPresenceAvailable();
        this.learnerImAvailable = lesson.getLearnerImAvailable();
        this.liveEditEnabled = lesson.getLiveEditEnabled();
        this.locked_for_edit = lesson.getLockedForEdit();
        this.isPreview = lesson.isPreviewLesson();
        this.enabledLessonNotifications = lesson.getEnableLessonNotifications();
        this.enableLessonIntro = lesson.isEnableLessonIntro();
        this.gradebookOnComplete = lesson.getGradebookOnComplete();
    }

    public Date getScheduleEndDate() {
        return this.scheduleEndDate;
    }

    public Date getScheduleStartDate() {
        return this.scheduleStartDate;
    }

    public String getScheduleStartDateStr() {
        return this.scheduleStartDateStr;
    }

    public void setScheduleStartDateStr(String scheduleStartDateStr) {
        this.scheduleStartDateStr = scheduleStartDateStr;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public String getCreateDateTimeStr() {
        return this.createDateTimeStr;
    }

    public void setCreateDateTimeStr(String createDateTimeStr) {
        this.createDateTimeStr = createDateTimeStr;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getLearningDesignID() {
        return this.learningDesignID;
    }

    public Long getLessonID() {
        return this.lessonID;
    }

    public Integer getLessonStateID() {
        return this.lessonStateID;
    }

    public Long getLicenseID() {
        return this.licenseID;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public String getOrganisationDescription() {
        return this.organisationDescription;
    }

    public Integer getOrganisationID() {
        return this.organisationID;
    }

    public String getOrganisationName() {
        return this.organisationName;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public String getStartDateTimeStr() {
        return this.startDateTimeStr;
    }

    public void setStartDateTimeStr(String startDateTimeStr) {
        this.startDateTimeStr = startDateTimeStr;
    }

    public Integer getWorkspaceFolderID() {
        return this.workspaceFolderID;
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public Integer getNumberStartedLearners() {
        return this.numberStartedLearners;
    }

    public void setNumberStartedLearners(Integer numberStartedLearners) {
        this.numberStartedLearners = numberStartedLearners;
    }

    public String getLessonDescription() {
        return this.lessonDescription;
    }

    public String getLessonName() {
        return this.lessonName;
    }

    public Integer getNumberPossibleLearners() {
        return this.numberPossibleLearners;
    }

    public Boolean getLearnerPresenceAvailable() {
        return this.learnerPresenceAvailable;
    }

    public Boolean getLearnerImAvailable() {
        return this.learnerImAvailable;
    }

    public Boolean getLockedForEdit() {
        return this.locked_for_edit;
    }

    public Boolean getLiveEditEnabled() {
        return this.liveEditEnabled;
    }

    public Boolean getLocked_for_edit() {
        return this.locked_for_edit;
    }

    public void setLocked_for_edit(Boolean locked_for_edit) {
        this.locked_for_edit = locked_for_edit;
    }

    public Boolean getIsPreview() {
        return this.isPreview;
    }

    public Boolean getEnabledLessonNotifications() {
        return this.enabledLessonNotifications;
    }

    public void setEnabledLessonNotifications(Boolean enabledLessonNotifications) {
        this.enabledLessonNotifications = enabledLessonNotifications;
    }

    public void setIsPreview(Boolean isPreview) {
        this.isPreview = isPreview;
    }

    public void setLessonID(Long lessonID) {
        this.lessonID = lessonID;
    }

    public void setLessonName(String lessonName) {
        this.lessonName = lessonName;
    }

    public void setLessonDescription(String lessonDescription) {
        this.lessonDescription = lessonDescription;
    }

    public void setLessonStateID(Integer lessonStateID) {
        this.lessonStateID = lessonStateID;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public void setScheduleStartDate(Date scheduleStartDate) {
        this.scheduleStartDate = scheduleStartDate;
    }

    public void setScheduleEndDate(Date scheduleEndDate) {
        this.scheduleEndDate = scheduleEndDate;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public void setOrganisationID(Integer organisationID) {
        this.organisationID = organisationID;
    }

    public void setOrganisationName(String organisationName) {
        this.organisationName = organisationName;
    }

    public void setOrganisationDescription(String organisationDescription) {
        this.organisationDescription = organisationDescription;
    }

    public void setWorkspaceFolderID(Integer workspaceFolderID) {
        this.workspaceFolderID = workspaceFolderID;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }

    public void setLicenseID(Long licenseID) {
        this.licenseID = licenseID;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public void setLearningDesignID(Long learningDesignID) {
        this.learningDesignID = learningDesignID;
    }

    public void setNumberPossibleLearners(Integer numberPossibleLearners) {
        this.numberPossibleLearners = numberPossibleLearners;
    }

    public void setLearnerPresenceAvailable(Boolean learnerPresenceAvailable) {
        this.learnerPresenceAvailable = learnerPresenceAvailable;
    }

    public void setLearnerImAvailable(Boolean learnerImAvailable) {
        this.learnerImAvailable = learnerImAvailable;
    }

    public void setLiveEditEnabled(Boolean liveEditEnabled) {
        this.liveEditEnabled = liveEditEnabled;
    }

    public String getEncodedLessonID() {
        return this.encodedLessonID;
    }

    public void setEncodedLessonID(String encodedLessonID) {
        this.encodedLessonID = encodedLessonID;
    }

    public Boolean getEnableLessonIntro() {
        return this.enableLessonIntro;
    }

    public void setEnableLessonIntro(Boolean enableLessonIntro) {
        this.enableLessonIntro = enableLessonIntro;
    }

    public Boolean getGradebookOnComplete() {
        return this.gradebookOnComplete;
    }

    public void setGradebookOnComplete(Boolean gradebookOnComplete) {
        this.gradebookOnComplete = gradebookOnComplete;
    }
}

