/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.logevent.service;

import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.logevent.LogEvent;
import org.lamsfoundation.lams.logevent.dao.ILogEventDAO;
import org.lamsfoundation.lams.logevent.service.ILogEventService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;

public class LogEventService
implements ILogEventService {
    private Logger log = Logger.getLogger(LogEventService.class);
    private static LogEventService instance;
    private ILogEventDAO logEventDAO;
    private IUserManagementService userManagementService;

    public LogEventService() {
        if (instance == null) {
            instance = this;
        }
    }

    public static LogEventService getInstance() {
        return instance;
    }

    @Override
    public void logEvent(Integer logEventTypeId, Integer userId, Long learningDesignId, Long lessonId, Long activityId) {
        User user;
        User user2 = user = userId != null ? (User)this.userManagementService.findById(User.class, userId) : null;
        if (user == null) {
            throw new RuntimeException("User can't be null");
        }
        LogEvent logEvent = new LogEvent();
        logEvent.setLogEventTypeId(logEventTypeId);
        logEvent.setUser(user);
        logEvent.setLearningDesignId(learningDesignId);
        logEvent.setLessonId(lessonId);
        logEvent.setActivityId(activityId);
        this.logEventDAO.save(logEvent);
    }

    @Override
    public LogEvent getLogEventById(Long logEventId) {
        return this.logEventDAO.getById(logEventId);
    }

    @Override
    public List<LogEvent> getLogEventByUser(Integer userId) {
        return this.logEventDAO.getByUser(userId);
    }

    @Override
    public List<LogEvent> getEventsOccurredBetween(Date startDate, Date finishDate) {
        return this.logEventDAO.getEventsOccurredBetween(startDate, finishDate);
    }

    public void setLogEventDAO(ILogEventDAO logEventDAO) {
        this.logEventDAO = logEventDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }
}

