/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.rating.service;

import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.json.JSONArray;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.rating.RatingException;
import org.lamsfoundation.lams.rating.dao.IRatingCommentDAO;
import org.lamsfoundation.lams.rating.dao.IRatingCriteriaDAO;
import org.lamsfoundation.lams.rating.dao.IRatingDAO;
import org.lamsfoundation.lams.rating.dto.ItemRatingCriteriaDTO;
import org.lamsfoundation.lams.rating.dto.ItemRatingDTO;
import org.lamsfoundation.lams.rating.dto.RatingCommentDTO;
import org.lamsfoundation.lams.rating.dto.StyledCriteriaRatingDTO;
import org.lamsfoundation.lams.rating.dto.StyledRatingDTO;
import org.lamsfoundation.lams.rating.model.LearnerItemRatingCriteria;
import org.lamsfoundation.lams.rating.model.Rating;
import org.lamsfoundation.lams.rating.model.RatingComment;
import org.lamsfoundation.lams.rating.model.RatingCriteria;
import org.lamsfoundation.lams.rating.service.IRatingService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;

public class RatingService
implements IRatingService {
    private static Logger log = Logger.getLogger(RatingService.class);
    private IRatingDAO ratingDAO;
    private IRatingCommentDAO ratingCommentDAO;
    private IRatingCriteriaDAO ratingCriteriaDAO;
    protected IUserManagementService userManagementService;
    protected MessageService messageService;

    @Override
    public Rating getRatingByItemAndUser(Long itemId, Integer userId) {
        return null;
    }

    @Override
    public List<Rating> getRatingsByItem(Long itemId) {
        return null;
    }

    @Override
    public int getCountItemsRatedByUser(Long toolContentId, Integer userId) {
        return this.ratingDAO.getCountItemsRatedByUser(toolContentId, userId);
    }

    @Override
    public int getCountItemsRatedByUserByCriteria(Long criteriaId, Integer userId) {
        return this.ratingDAO.getCountItemsRatedByUserByCriteria(criteriaId, userId);
    }

    @Override
    public void removeUserCommitsByContent(Long contentId, Integer userId) {
        List<Rating> ratings = this.ratingDAO.getRatingsByUser(contentId, userId);
        for (Rating rating : ratings) {
            this.ratingDAO.delete(rating);
        }
        List<RatingComment> comments = this.ratingCommentDAO.getCommentsByContentAndUser(contentId, userId);
        for (RatingComment comment : comments) {
            this.ratingDAO.delete(comment);
        }
    }

    @Override
    public Map<Long, Long> countUsersRatedEachItem(Long contentId, Long toolSessionId, Collection<Long> itemIds, Integer excludeUserId) {
        return this.ratingDAO.countUsersRatedEachItem(contentId, toolSessionId, itemIds, excludeUserId);
    }

    @Override
    public Map<Long, Long> countUsersRatedEachItemByCriteria(Long criteriaId, Long toolSessionId, Collection<Long> itemIds, Integer excludeUserId) {
        return this.ratingDAO.countUsersRatedEachItemByCriteria(criteriaId, toolSessionId, itemIds, excludeUserId);
    }

    @Override
    public void saveOrUpdateRating(Rating rating) {
        this.ratingDAO.saveOrUpdate(rating);
    }

    @Override
    public ItemRatingCriteriaDTO rateItem(RatingCriteria ratingCriteria, Long toolSessionId, Integer userId, Long itemId, float ratingFloat) {
        Long ratingCriteriaId = ratingCriteria.getRatingCriteriaId();
        Rating rating = this.ratingDAO.getRating(ratingCriteriaId, userId, itemId);
        if (rating == null) {
            rating = new Rating();
            rating.setItemId(itemId);
            User learner = (User)this.userManagementService.findById(User.class, userId);
            rating.setLearner(learner);
            rating.setRatingCriteria(ratingCriteria);
            rating.setToolSessionId(toolSessionId);
        }
        rating.setRating(Float.valueOf(ratingFloat));
        this.ratingDAO.saveOrUpdate(rating);
        return this.ratingDAO.getRatingAverageDTOByItem(ratingCriteriaId, toolSessionId, itemId);
    }

    @Override
    public int rateItems(RatingCriteria ratingCriteria, Long toolSessionId, Integer userId, Map<Long, Float> newRatings) {
        User learner = (User)this.userManagementService.findById(User.class, userId);
        int numRatings = 0;
        List<Rating> dbRatings = this.ratingDAO.getRatingsByUserCriteria(ratingCriteria.getRatingCriteriaId(), userId);
        for (Rating rating : dbRatings) {
            Long itemId = rating.getItemId();
            Float newRating = newRatings.get(itemId);
            if (newRating != null) {
                rating.setRating(newRating);
                newRatings.remove(itemId);
                ++numRatings;
                this.ratingDAO.saveOrUpdate(rating);
                continue;
            }
            rating.setRating(null);
        }
        for (Map.Entry entry : newRatings.entrySet()) {
            Rating rating = new Rating();
            rating.setItemId((Long)entry.getKey());
            rating.setLearner(learner);
            rating.setRatingCriteria(ratingCriteria);
            rating.setRating((Float)entry.getValue());
            rating.setToolSessionId(toolSessionId);
            this.ratingDAO.saveOrUpdate(rating);
            ++numRatings;
        }
        return numRatings;
    }

    @Override
    public void commentItem(RatingCriteria ratingCriteria, Long toolSessionId, Integer userId, Long itemId, String comment) {
        RatingComment ratingComment = this.ratingCommentDAO.getComment(ratingCriteria.getRatingCriteriaId(), userId, itemId);
        if (ratingComment == null) {
            ratingComment = new RatingComment();
            ratingComment.setItemId(itemId);
            User learner = (User)this.userManagementService.findById(User.class, userId);
            ratingComment.setLearner(learner);
            ratingComment.setRatingCriteria(ratingCriteria);
            ratingComment.setToolSessionId(toolSessionId);
        }
        ratingComment.setComment(comment);
        this.ratingDAO.saveOrUpdate(ratingComment);
    }

    @Override
    public List<ItemRatingDTO> getRatingCriteriaDtos(Long contentId, Long toolSessionId, Collection<Long> itemIds, boolean isCommentsByOtherUsersRequired, Long userId) {
        if (itemIds == null || itemIds.isEmpty()) {
            return new LinkedList<ItemRatingDTO>();
        }
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMaximumFractionDigits(1);
        List<RatingCriteria> criterias = this.getCriteriasByToolContentId(contentId);
        boolean isSingleItem = itemIds.size() == 1;
        Long singleItemId = isSingleItem ? itemIds.iterator().next() : null;
        List<ItemRatingDTO> itemDtos = this.handleCommentsCriteria(criterias, toolSessionId, itemIds, isCommentsByOtherUsersRequired, userId);
        List<Rating> userRatings = this.ratingDAO.getRatingsByUser(contentId, userId.intValue());
        List<Object[]> itemsStatistics = isSingleItem ? this.ratingDAO.getRatingAverageByContentAndItem(contentId, toolSessionId, singleItemId) : this.ratingDAO.getRatingAverageByContentAndItems(contentId, toolSessionId, itemIds);
        for (ItemRatingDTO itemDto : itemDtos) {
            Long itemId = itemDto.getItemId();
            LinkedList<ItemRatingCriteriaDTO> criteriaDtos = new LinkedList<ItemRatingCriteriaDTO>();
            itemDto.setCriteriaDtos(criteriaDtos);
            for (RatingCriteria criteria : criterias) {
                Long criteriaId = criteria.getRatingCriteriaId();
                if (criteria.getRatingStyle() == 0) continue;
                ItemRatingCriteriaDTO criteriaDto = new ItemRatingCriteriaDTO();
                criteriaDto.setRatingCriteria(criteria);
                Rating userRating = null;
                for (Rating userRatingIter : userRatings) {
                    if (!userRatingIter.getItemId().equals(itemId) || !userRatingIter.getRatingCriteria().getRatingCriteriaId().equals(criteriaId)) continue;
                    userRating = userRatingIter;
                }
                String userRatingStr = userRating == null ? "" : numberFormat.format(userRating.getRating());
                criteriaDto.setUserRating(userRatingStr);
                Object[] itemStatistics = null;
                for (Object[] itemStatisticsIter : itemsStatistics) {
                    Long itemIdIter = (Long)itemStatisticsIter[0];
                    Long ratingCriteriaIdIter = (Long)itemStatisticsIter[1];
                    if (!itemIdIter.equals(itemId) || !ratingCriteriaIdIter.equals(criteriaId)) continue;
                    itemStatistics = itemStatisticsIter;
                }
                if (itemStatistics != null) {
                    Number averageRating = (Number)itemStatistics[2];
                    criteriaDto.setAverageRating(numberFormat.format(averageRating));
                    criteriaDto.setAverageRatingAsNumber(averageRating);
                    criteriaDto.setNumberOfVotes(String.valueOf(itemStatistics[3]));
                } else {
                    criteriaDto.setAverageRating("0");
                    criteriaDto.setAverageRatingAsNumber(0);
                    criteriaDto.setNumberOfVotes("0");
                }
                criteriaDtos.add(criteriaDto);
            }
        }
        return itemDtos;
    }

    private List<ItemRatingDTO> handleCommentsCriteria(List<RatingCriteria> criterias, Long toolSessionId, Collection<Long> itemIds, boolean isCommentsByOtherUsersRequired, Long userId) {
        boolean isSingleItem = itemIds.size() == 1;
        Long singleItemId = isSingleItem ? itemIds.iterator().next() : null;
        List<ItemRatingDTO> itemDtos = this.initializeItemDtos(itemIds);
        for (RatingCriteria criteria : criterias) {
            if (!criteria.isCommentRating()) continue;
            Long commentCriteriaId = criteria.getRatingCriteriaId();
            List<RatingCommentDTO> commentDtos = isSingleItem ? this.ratingCommentDAO.getCommentsByCriteriaAndItem(commentCriteriaId, toolSessionId, singleItemId) : (isCommentsByOtherUsersRequired ? this.ratingCommentDAO.getCommentsByCriteriaAndItems(commentCriteriaId, toolSessionId, itemIds) : this.ratingCommentDAO.getCommentsByCriteriaAndItemsAndUser(commentCriteriaId, itemIds, userId.intValue()));
            for (ItemRatingDTO itemDto : itemDtos) {
                itemDto.setCommentsEnabled(true);
                itemDto.setCommentsCriteriaId(commentCriteriaId);
                itemDto.setCommentsMinWordsLimit(criteria.getCommentsMinWordsLimit());
                LinkedList<RatingCommentDTO> commentDtosPerItem = new LinkedList<RatingCommentDTO>();
                for (RatingCommentDTO commentDto : commentDtos) {
                    if (!commentDto.getItemId().equals(itemDto.getItemId())) continue;
                    commentDtosPerItem.add(commentDto);
                    if (!commentDto.getUserId().equals(userId)) continue;
                    itemDto.setCommentPostedByUser(commentDto);
                }
                itemDto.setCommentDtos(commentDtosPerItem);
            }
        }
        return itemDtos;
    }

    private List<ItemRatingDTO> initializeItemDtos(Collection<Long> itemIds) {
        LinkedList<ItemRatingDTO> itemDtos = new LinkedList<ItemRatingDTO>();
        for (Long itemId : itemIds) {
            ItemRatingDTO itemDto = new ItemRatingDTO();
            itemDto.setItemId(itemId);
            itemDtos.add(itemDto);
        }
        return itemDtos;
    }

    @Override
    public List<RatingCriteria> getCriteriasByToolContentId(Long toolContentId) {
        List<RatingCriteria> criterias = this.ratingCriteriaDAO.getByToolContentId(toolContentId);
        return criterias;
    }

    @Override
    public RatingCriteria getCriteriaByCriteriaId(Long ratingCriteriaId) {
        return this.ratingCriteriaDAO.getByRatingCriteriaId(ratingCriteriaId);
    }

    @Override
    public RatingCriteria getCriteriaByCriteriaId(Long ratingCriteriaId, Class clasz) {
        return this.ratingCriteriaDAO.getByRatingCriteriaId(ratingCriteriaId, clasz);
    }

    private LearnerItemRatingCriteria updateLearnerItemRatingCriteria(LearnerItemRatingCriteria oldCriteria, Long toolContentId, String title, Integer orderId, int ratingStyle, boolean withComments, int minWordsInComment) {
        LearnerItemRatingCriteria criteria = oldCriteria != null ? oldCriteria : new LearnerItemRatingCriteria();
        criteria.setRatingCriteriaTypeId(3);
        criteria.setToolContentId(toolContentId);
        criteria.setRatingStyle(ratingStyle);
        criteria.setOrderId(orderId);
        criteria.setTitle(title);
        criteria.setCommentsEnabled(withComments);
        criteria.setCommentsMinWordsLimit(minWordsInComment);
        criteria.setMinimumRates(null);
        criteria.setMaximumRates(null);
        Integer maxRating = null;
        switch (ratingStyle) {
            case 1: {
                maxRating = 5;
                break;
            }
            case 2: {
                maxRating = 5;
                break;
            }
            case 0: 
            case 3: {
                maxRating = 0;
            }
        }
        criteria.setMaxRating(maxRating);
        return criteria;
    }

    @Override
    public LearnerItemRatingCriteria saveLearnerItemRatingCriteria(Long toolContentId, String title, Integer orderId, int ratingStyle, boolean withComments, int minWordsInComment) throws RatingException {
        Iterator<RatingCriteria> iterator;
        List<RatingCriteria> criterias = this.ratingCriteriaDAO.getByToolContentId(toolContentId);
        LearnerItemRatingCriteria criteria = null;
        if (criterias.size() > 0 && (iterator = criterias.iterator()).hasNext()) {
            RatingCriteria c = iterator.next();
            if (c.getOrderId().equals(orderId) && !c.isLearnerItemRatingCriteria()) {
                String msg = "Wrong type of criteria found - needs to be a AuthoredItemRatingCriteria for toolContentId " + toolContentId + "criteriaId " + c.getRatingCriteriaId();
                log.error((Object)msg);
                throw new RatingException(msg);
            }
            criteria = (LearnerItemRatingCriteria)c;
        }
        criteria = this.updateLearnerItemRatingCriteria(criteria, toolContentId, title, orderId, ratingStyle, withComments, minWordsInComment);
        this.ratingCriteriaDAO.saveOrUpdate(criteria);
        return criteria;
    }

    @Override
    public int deleteAllRatingCriterias(Long toolContentId) {
        List<RatingCriteria> criterias = this.ratingCriteriaDAO.getByToolContentId(toolContentId);
        int count = 0;
        for (RatingCriteria criteria : criterias) {
            this.ratingCriteriaDAO.deleteRatingCriteria(criteria.getRatingCriteriaId());
            ++count;
        }
        return count;
    }

    @Override
    public void saveRatingCriterias(HttpServletRequest request, Collection<RatingCriteria> oldCriterias, Long toolContentId) {
        boolean explicitCommentTypeFound = false;
        HashMap<Integer, RatingCriteria> mapOrderIdToRatingCriteria = new HashMap<Integer, RatingCriteria>();
        for (RatingCriteria ratingCriteriaIter : oldCriterias) {
            mapOrderIdToRatingCriteria.put(ratingCriteriaIter.getOrderId(), ratingCriteriaIter);
        }
        int criteriaMaxOrderId = WebUtil.readIntParam(request, "criteriaMaxOrderId");
        for (int i = 1; i <= criteriaMaxOrderId; ++i) {
            Integer maxRating;
            String criteriaTitle = WebUtil.readStrParam(request, "criteriaTitle" + i, true);
            Object ratingStyle = WebUtil.readIntParam(request, "ratingStyle" + i, true);
            if (ratingStyle == null) {
                ratingStyle = 1;
            }
            if ((maxRating = WebUtil.readIntParam(request, "maxRating" + i, true)) == null) {
                switch ((Integer)ratingStyle) {
                    case 1: {
                        maxRating = 5;
                        break;
                    }
                    case 2: {
                        maxRating = 5;
                        break;
                    }
                    case 0: 
                    case 3: {
                        maxRating = 0;
                    }
                }
            }
            Integer minRatings = 0;
            Integer maxRatings = 0;
            if ((Integer)ratingStyle == 1 || (Integer)ratingStyle == 0) {
                minRatings = WebUtil.readIntParam(request, "minimumRates" + i, true);
                maxRatings = WebUtil.readIntParam(request, "maximumRates" + i, true);
            }
            boolean commentsEnabled = (Integer)ratingStyle != 0 ? WebUtil.readBooleanParam(request, "enableComments" + i, false) : true;
            RatingCriteria ratingCriteria = (RatingCriteria)mapOrderIdToRatingCriteria.get(i);
            if ((Integer)ratingStyle == 0 || ratingCriteria != null && ratingCriteria.isCommentRating()) {
                explicitCommentTypeFound = true;
            }
            if (StringUtils.isNotBlank((String)criteriaTitle)) {
                int newCriteriaOrderId = WebUtil.readIntParam(request, "criteriaOrderId" + i);
                if (ratingCriteria == null) {
                    ratingCriteria = new LearnerItemRatingCriteria();
                    ratingCriteria.setRatingCriteriaTypeId(3);
                    ((LearnerItemRatingCriteria)ratingCriteria).setToolContentId(toolContentId);
                }
                ratingCriteria.setOrderId(newCriteriaOrderId);
                ratingCriteria.setTitle(criteriaTitle);
                ratingCriteria.setRatingStyle((Integer)ratingStyle);
                ratingCriteria.setMaxRating(maxRating);
                ratingCriteria.setCommentsEnabled(commentsEnabled);
                if (commentsEnabled) {
                    Integer commentsMinWordsLimit = WebUtil.readIntParam(request, "commentsMinWordsLimit" + i, true);
                    ratingCriteria.setCommentsMinWordsLimit(commentsMinWordsLimit != null ? commentsMinWordsLimit : 0);
                } else {
                    ratingCriteria.setCommentsMinWordsLimit(0);
                }
                ratingCriteria.setMinimumRates(minRatings);
                ratingCriteria.setMaximumRates(maxRatings);
                this.ratingCriteriaDAO.saveOrUpdate(ratingCriteria);
                continue;
            }
            if (ratingCriteria == null) continue;
            this.ratingCriteriaDAO.deleteRatingCriteria(ratingCriteria.getRatingCriteriaId());
        }
        if (!explicitCommentTypeFound) {
            boolean isCommentsEnabled = WebUtil.readBooleanParam(request, "isCommentsEnabled", false);
            RatingCriteria commentsResponsibleCriteria = null;
            for (RatingCriteria ratingCriteriaIter : oldCriterias) {
                if (!ratingCriteriaIter.isCommentRating()) continue;
                commentsResponsibleCriteria = ratingCriteriaIter;
                break;
            }
            if (isCommentsEnabled) {
                if (commentsResponsibleCriteria == null) {
                    commentsResponsibleCriteria = new LearnerItemRatingCriteria();
                    commentsResponsibleCriteria.setRatingCriteriaTypeId(3);
                    ((LearnerItemRatingCriteria)commentsResponsibleCriteria).setToolContentId(toolContentId);
                    commentsResponsibleCriteria.setOrderId(0);
                    commentsResponsibleCriteria.setCommentsEnabled(true);
                    commentsResponsibleCriteria.setRatingStyle(0);
                }
                int commentsMinWordsLimit = WebUtil.readIntParam(request, "commentsMinWordsLimit");
                commentsResponsibleCriteria.setCommentsMinWordsLimit(commentsMinWordsLimit);
                this.ratingCriteriaDAO.saveOrUpdate(commentsResponsibleCriteria);
            } else if (commentsResponsibleCriteria != null) {
                this.ratingCriteriaDAO.deleteRatingCriteria(commentsResponsibleCriteria.getRatingCriteriaId());
            }
        }
    }

    @Override
    public StyledCriteriaRatingDTO convertToStyledDTO(RatingCriteria ratingCriteria, Long currentUserId, boolean includeCurrentUser, List<Object[]> rawDataRows) {
        StyledCriteriaRatingDTO criteriaDto = new StyledCriteriaRatingDTO();
        criteriaDto.setRatingCriteria(ratingCriteria);
        if (ratingCriteria.isHedgeStyleRating() && ratingCriteria.isCommentsEnabled()) {
            RatingComment justification = this.ratingCommentDAO.getComment(ratingCriteria.getRatingCriteriaId(), currentUserId.intValue(), ratingCriteria.getRatingCriteriaId());
            if (justification != null) {
                criteriaDto.setJustificationComment(justification.getComment());
            }
        } else if (ratingCriteria.isStarStyleRating()) {
            int ratedCount = this.getCountItemsRatedByUserByCriteria(ratingCriteria.getRatingCriteriaId(), currentUserId.intValue());
            criteriaDto.setCountRatedItems(ratedCount);
        }
        boolean isComment = ratingCriteria.isCommentRating();
        if (rawDataRows != null) {
            ArrayList<StyledRatingDTO> ratingDtos = new ArrayList<StyledRatingDTO>();
            criteriaDto.setRatingDtos(ratingDtos);
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(1);
            for (Object[] row : rawDataRows) {
                int numColumns = row.length;
                if (isComment && numColumns < 4 || !isComment && numColumns < 7) {
                    StringBuffer buf = new StringBuffer("convertToStyledDTO: ratingCriteria").append(ratingCriteria.getRatingCriteriaId()).append(" UserId: ").append(currentUserId).append("  Skipping data row as there are not enough columns. Only ").append(numColumns).append(" columns. numColumns: ").append(numColumns);
                    if (numColumns > 0) {
                        buf.append(" Data: 0:").append(row[0]);
                    }
                    if (numColumns > 1) {
                        buf.append(" 1:").append(row[1]);
                    }
                    log.error((Object)buf.toString());
                    break;
                }
                long itemId = ((BigInteger)row[0]).longValue();
                if (!includeCurrentUser && itemId == currentUserId) continue;
                if (row[1] != null && itemId != ((BigInteger)row[0]).longValue()) {
                    log.error((Object)("convertToStyledDTO: ratingCriteria" + ratingCriteria.getRatingCriteriaId() + " UserId: " + currentUserId + "  Potential issue: expected item id " + row[0] + " does match real item id " + row[1] + ". Data: 0:" + row[0] + " 1:" + row[1]));
                }
                StyledRatingDTO dto = new StyledRatingDTO(((BigInteger)row[0]).longValue());
                dto.setComment((String)row[2]);
                dto.setItemDescription(row[numColumns - 2] != null ? row[numColumns - 2].toString() : null);
                dto.setItemDescription2(row[numColumns - 1] != null ? row[numColumns - 1].toString() : null);
                if (!isComment) {
                    dto.setUserRating(row[3] == null ? "" : numberFormat.format((Double)row[3]));
                    dto.setAverageRating(row[4] == null ? "" : numberFormat.format((Double)row[4]));
                    dto.setNumberOfVotes(row[5] == null ? "" : numberFormat.format((BigInteger)row[5]));
                }
                ratingDtos.add(dto);
            }
        }
        return criteriaDto;
    }

    @Override
    public JSONArray convertToStyledJSON(RatingCriteria ratingCriteria, Long toolSessionId, Long currentUserId, boolean includeCurrentUser, List<Object[]> rawDataRows, boolean needRatesPerUser) throws JSONException {
        JSONArray rows = new JSONArray();
        boolean isComment = ratingCriteria.isCommentRating();
        if (rawDataRows != null) {
            ArrayList<Long> itemIds = needRatesPerUser ? new ArrayList<Long>(rawDataRows.size()) : null;
            NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
            numberFormat.setMaximumFractionDigits(1);
            for (Object[] row : rawDataRows) {
                int numColumns = row.length;
                if (isComment && numColumns < 4 || !isComment && numColumns < 7) {
                    StringBuffer buf = new StringBuffer("convertToStyledJSON: ratingCriteria").append(ratingCriteria.getRatingCriteriaId()).append(" UserId: ").append(currentUserId).append("  Skipping data row as there are not enough columns. Only ").append(numColumns).append(" columns. numColumns: ").append(numColumns);
                    if (numColumns > 0) {
                        buf.append(" Data: 0:").append(row[0]);
                    }
                    if (numColumns > 1) {
                        buf.append(" 1:").append(row[1]);
                    }
                    log.error((Object)buf.toString());
                    break;
                }
                Long itemId = ((BigInteger)row[0]).longValue();
                if (!includeCurrentUser && itemId == currentUserId) continue;
                if (row[1] != null && itemId.longValue() != ((BigInteger)row[0]).longValue()) {
                    log.error((Object)("convertToStyledJSON: ratingCriteria" + ratingCriteria.getRatingCriteriaId() + " UserId: " + currentUserId + "  Potential issue: expected item id " + row[0] + " does match real item id " + row[1] + ". Data: 0:" + row[0] + " 1:" + row[1]));
                }
                JSONObject userRow = new JSONObject();
                userRow.put("itemId", (Object)itemId);
                userRow.put("comment", (Object)(row[2] == null ? "" : (String)row[2]));
                userRow.put("itemDescription", (Object)(row[numColumns - 2] == null ? "" : row[numColumns - 2].toString()));
                userRow.put("itemDescription2", (Object)(row[numColumns - 1] == null ? "" : row[numColumns - 1].toString()));
                if (!isComment) {
                    userRow.put("userRating", (Object)(row[3] == null ? "" : numberFormat.format((Double)row[3])));
                    userRow.put("averageRating", (Object)(row[4] == null ? "" : numberFormat.format((Double)row[4])));
                    userRow.put("numberOfVotes", (Object)(row[5] == null ? "" : numberFormat.format((BigInteger)row[5])));
                } else {
                    userRow.put("userRating", (Object)"");
                    userRow.put("averageRating", (Object)"");
                    userRow.put("numberOfVotes", (Object)"");
                }
                rows.put((Object)userRow);
                if (!needRatesPerUser) continue;
                itemIds.add(itemId);
            }
            if (needRatesPerUser) {
                Map<Long, Long> countUsersRatedEachItemMap = this.ratingDAO.countUsersRatedEachItemByCriteria(ratingCriteria.getRatingCriteriaId(), toolSessionId, itemIds, -1);
                for (int i = 0; i < rows.length(); ++i) {
                    JSONObject row;
                    Long count = countUsersRatedEachItemMap.get((row = rows.getJSONObject(i)).get("itemId"));
                    row.put("ratesPerUser", count != null ? count : 0L);
                }
            }
        }
        return rows;
    }

    @Override
    public boolean isCommentsEnabled(Long toolContentId) {
        return this.ratingCriteriaDAO.isCommentsEnabledForToolContent(toolContentId);
    }

    @Override
    public int getCommentsMinWordsLimit(Long toolContentId) {
        return this.ratingCriteriaDAO.getCommentsMinWordsLimitForToolContent(toolContentId);
    }

    @Override
    public String getRatingSelectJoinSQL(Integer ratingStyle, boolean getByUser) {
        return this.ratingDAO.getRatingSelectJoinSQL(ratingStyle, getByUser);
    }

    @Override
    public List getRatingsByCriteriasAndItems(Collection<Long> ratingCriteriaIds, Collection<Long> itemIds) {
        return this.ratingDAO.getRatingsByCriteriasAndItems(ratingCriteriaIds, itemIds);
    }

    public void setRatingDAO(IRatingDAO ratingDAO) {
        this.ratingDAO = ratingDAO;
    }

    public void setRatingCommentDAO(IRatingCommentDAO ratingCommentDAO) {
        this.ratingCommentDAO = ratingCommentDAO;
    }

    public void setRatingCriteriaDAO(IRatingCriteriaDAO ratingCriteriaDAO) {
        this.ratingCriteriaDAO = ratingCriteriaDAO;
    }

    public void setUserManagementService(IUserManagementService userManagementService) {
        this.userManagementService = userManagementService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }
}

