/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.SMTPAuthenticator;

public class Emailer {
    public static void sendFromSupportEmail(String subject, String to, String body, boolean isHtmlFormat) throws AddressException, MessagingException, UnsupportedEncodingException {
        Emailer.sendFromSupportEmail(subject, to, body, isHtmlFormat, null);
    }

    public static void sendFromSupportEmail(String subject, String to, String body, boolean isHtmlFormat, String attachmentFilename) throws AddressException, MessagingException, UnsupportedEncodingException {
        String supportEmail = Configuration.get(ConfigurationKeys.LAMS_ADMIN_EMAIL);
        Emailer.send(subject, to, "", supportEmail, "", body, isHtmlFormat, attachmentFilename);
    }

    public static Session getMailSession() {
        String smtpServer = Configuration.get(ConfigurationKeys.SMTP_SERVER);
        Properties properties = new Properties();
        properties.put("mail.smtp.host", smtpServer);
        String smtpAuthUser = Configuration.get(ConfigurationKeys.SMTP_AUTH_USER);
        String smtpAuthPass = Configuration.get(ConfigurationKeys.SMTP_AUTH_PASSWORD);
        Session session = null;
        if (StringUtils.isBlank((String)smtpAuthUser)) {
            session = Session.getInstance((Properties)properties);
        } else {
            properties.setProperty("mail.smtp.submitter", smtpAuthUser);
            properties.setProperty("mail.smtp.auth", "true");
            SMTPAuthenticator auth = new SMTPAuthenticator(smtpAuthUser, smtpAuthPass);
            session = Session.getInstance((Properties)properties, (Authenticator)auth);
        }
        return session;
    }

    public static void send(String subject, String to, String toPerson, String from, String fromPerson, String body, boolean isHtmlFormat) throws AddressException, MessagingException, UnsupportedEncodingException {
        Emailer.send(subject, to, toPerson, from, fromPerson, body, isHtmlFormat, null);
    }

    public static void send(String subject, String to, String toPerson, String from, String fromPerson, String body, boolean isHtmlFormat, String filename) throws AddressException, MessagingException, UnsupportedEncodingException {
        Session session = Emailer.getMailSession();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(from, fromPerson));
        message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to, toPerson));
        message.setSubject(subject, "UTF-8");
        if (filename == null) {
            message.setText(body, "UTF-8");
            String contentType = isHtmlFormat ? "text/html;charset=UTF-8" : "text/plain;charset=UTF-8";
            message.addHeader("Content-Type", contentType);
        } else {
            MimeBodyPart msgPart = new MimeBodyPart();
            msgPart.setText(body, "UTF-8");
            String contentType = isHtmlFormat ? "text/html;charset=UTF-8" : "text/plain;charset=UTF-8";
            msgPart.addHeader("Content-Type", contentType);
            MimeBodyPart filePart = new MimeBodyPart();
            FileDataSource fds = new FileDataSource(filename);
            filePart.setDataHandler(new DataHandler((DataSource)fds));
            String encodedFilename = MimeUtility.encodeText((String)fds.getName());
            filePart.setFileName(encodedFilename);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)msgPart);
            mp.addBodyPart((BodyPart)filePart);
            message.setContent((Multipart)mp);
        }
        Transport.send((Message)message);
    }
}

