/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.text.NumberFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class FileValidatorUtil {
    public static final String LARGE_FILE = "largeFile";
    private static final String MSG_KEY = "errors.maxfilesize";

    public static boolean validateFileSize(Object bean, ValidatorAction va, Field field, ActionMessages errors, Validator validator, HttpServletRequest request) {
        int fileSize = 0;
        try {
            String fileSizeStr = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
            fileSize = Integer.parseInt(fileSizeStr);
        }
        catch (Exception e) {
            return true;
        }
        boolean largeFile = Boolean.valueOf(field.getVarValue(LARGE_FILE));
        return FileValidatorUtil.validateFileSize(fileSize, largeFile, "org.apache.struts.action.GLOBAL_MESSAGE", errors);
    }

    public static boolean validateFileSize(FormFile file, boolean largeFile, ActionMessages errors) {
        return FileValidatorUtil.validateFileSize(file, largeFile, "org.apache.struts.action.GLOBAL_MESSAGE", errors);
    }

    public static boolean validateFileSize(FormFile file, boolean largeFile, String errorKey, ActionMessages errors) {
        int fileSize = 0;
        try {
            fileSize = file.getFileSize();
        }
        catch (Exception e) {
            return true;
        }
        return FileValidatorUtil.validateFileSize(fileSize, largeFile, errorKey, errors);
    }

    public static ActionMessage validateFileSize(FileItem file, boolean largeFile) {
        boolean isMaxFilesizeExceeded;
        int fileSize = (int)file.getSize();
        ActionMessages errors = new ActionMessages();
        ActionMessage errorMessage = null;
        boolean bl = isMaxFilesizeExceeded = !FileValidatorUtil.validateFileSize(fileSize, largeFile, "org.apache.struts.action.GLOBAL_MESSAGE", errors);
        if (isMaxFilesizeExceeded) {
            errorMessage = (ActionMessage)errors.get().next();
        }
        return errorMessage;
    }

    private static boolean validateFileSize(int fileSize, boolean largeFile, String errorKey, ActionMessages errors) {
        float maxFileSize;
        float f = maxFileSize = largeFile ? (float)Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_LARGE_MAX_SIZE) : (float)Configuration.getAsInt(ConfigurationKeys.UPLOAD_FILE_MAX_SIZE);
        if ((float)fileSize > maxFileSize) {
            String maxSize = FileValidatorUtil.formatSize(maxFileSize);
            errors.add(errorKey, new ActionMessage(MSG_KEY, (Object)maxSize));
            return false;
        }
        return true;
    }

    public static String formatSize(double size) {
        String unit = null;
        if (size >= 1024.0) {
            if ((size /= 1024.0) >= 1024.0) {
                size /= 1024.0;
                unit = " MB";
            } else {
                unit = " KB";
            }
        } else {
            unit = " B";
        }
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(1);
        return format.format(size) + unit;
    }
}

