/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.util.HashMap;
import org.lamsfoundation.lams.util.ILoadedMessageSourceService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;

public class LoadedMessageSourceService
implements ILoadedMessageSourceService,
BeanFactoryAware {
    private static final String LOADED_MESSAGE_SOURCE_BEAN = "loadedMessageSource";
    private HashMap<String, MessageSource> messageServices = new HashMap();
    private BeanFactory beanFactory = null;

    @Override
    public MessageSource getMessageService(String messageFilename) {
        if (messageFilename != null) {
            MessageSource ms = this.messageServices.get(messageFilename);
            if (ms == null) {
                ResourceBundleMessageSource rbms = (ResourceBundleMessageSource)this.beanFactory.getBean(LOADED_MESSAGE_SOURCE_BEAN);
                rbms.setBasename(messageFilename);
                this.messageServices.put(messageFilename, (MessageSource)rbms);
                ms = rbms;
            }
            return ms;
        }
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

