/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.json.JSONException;
import org.apache.tomcat.util.json.JSONObject;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class WebUtil {
    private static Logger log = Logger.getLogger(WebUtil.class);
    private static final String HTML_TAG_REGEX = "\\<.*?>";
    private static final String SPACE_TAG_REGEX = "(?:<BR>)|(?:&nbsp;)|(?:</div><div>)";
    private static final String URL_SHORTENING_CYPHER = "jbdnuteywk";

    public static boolean isTokenValid(HttpServletRequest req, String tokenName) {
        if (req.getSession() != null) {
            String valueSession = (String)req.getSession().getAttribute(tokenName);
            String valueRequest = req.getParameter(tokenName);
            log.debug((Object)("(Session Token) name : " + tokenName + " value : " + valueSession));
            log.debug((Object)("(Request Token) name : " + tokenName + " value : " + valueRequest));
            if (valueSession != null && valueRequest != null && valueSession.equals(valueRequest)) {
                return true;
            }
        }
        return false;
    }

    public static void saveTaskURL(HttpServletRequest req, String[] urls) {
        if (urls != null) {
            if (urls.length == 1) {
                req.setAttribute("urlA", (Object)urls[0]);
            } else if (urls.length == 2) {
                req.setAttribute("urlA", (Object)urls[0]);
                req.setAttribute("urlB", (Object)urls[1]);
            }
        }
    }

    public static void saveToken(HttpServletRequest req, String tokenName, String tokenValue) {
        if (req.getSession().getAttribute(tokenName) != null) {
            WebUtil.resetToken(req, tokenName);
        }
        req.getSession().setAttribute(tokenName, (Object)tokenValue);
        log.debug((Object)("(Save Session Token) name : " + tokenName + " value : " + tokenValue));
    }

    public static String retrieveToken(HttpServletRequest req, String tokenName) {
        return (String)req.getSession().getAttribute(tokenName);
    }

    public static void resetToken(HttpServletRequest req, String tokenName) {
        req.getSession().removeAttribute(tokenName);
    }

    public static void checkObject(String paramName, Object paramValue) throws IllegalArgumentException {
        boolean isNull;
        boolean bl = isNull = paramValue == null;
        if (!isNull && String.class.isInstance(paramValue)) {
            String str = (String)paramValue;
            boolean bl2 = isNull = str.trim().length() == 0;
        }
        if (isNull) {
            throw new IllegalArgumentException(paramName + " is required '" + paramValue + "'");
        }
    }

    public static Integer checkInteger(String paramName, String paramValue, boolean isOptional) throws IllegalArgumentException {
        try {
            if (!isOptional) {
                WebUtil.checkObject(paramName, paramValue);
            }
            String value = paramValue != null ? StringUtils.trimToNull((String)paramValue) : null;
            return value != null ? new Integer(value) : null;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be an integer '" + paramValue + "'");
        }
    }

    public static Long checkLong(String paramName, String paramValue, boolean isOptional) throws IllegalArgumentException {
        try {
            if (!isOptional) {
                WebUtil.checkObject(paramName, paramValue);
            }
            String value = paramValue != null ? StringUtils.trimToNull((String)paramValue) : null;
            return value != null ? new Long(value) : null;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(paramName + " should be a long '" + paramValue + "'");
        }
    }

    public static long checkLong(String paramName, Long paramValue, boolean isOptional) throws IllegalArgumentException {
        if (!isOptional) {
            WebUtil.checkObject(paramName, paramValue);
        }
        return paramValue;
    }

    public static boolean checkBoolean(String paramName, String paramValue) throws IllegalArgumentException {
        WebUtil.checkObject(paramName, paramValue);
        return Boolean.valueOf(paramValue.trim());
    }

    public static int readIntParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkInteger(paramName, req.getParameter(paramName), false);
    }

    public static Integer readIntParam(HttpServletRequest req, String paramName, boolean isOptional) {
        return WebUtil.checkInteger(paramName, req.getParameter(paramName), isOptional);
    }

    public static long readLongParam(HttpServletRequest req, String paramName) {
        return WebUtil.checkLong(paramName, req.getParameter(paramName), false);
    }

    public static Long readLongParam(HttpServletRequest req, String paramName, boolean isOptional) {
        return WebUtil.checkLong(paramName, req.getParameter(paramName), isOptional);
    }

    public static String readStrParam(HttpServletRequest req, String paramName) {
        return WebUtil.readStrParam(req, paramName, false);
    }

    public static String readStrParam(HttpServletRequest req, String paramName, boolean isOptional) {
        if (!isOptional) {
            WebUtil.checkObject(paramName, req.getParameter(paramName));
        }
        return req.getParameter(paramName);
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName) throws IllegalArgumentException {
        return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
    }

    public static boolean readBooleanParam(HttpServletRequest req, String paramName, boolean defaultValue) {
        try {
            return WebUtil.checkBoolean(paramName, req.getParameter(paramName));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public static boolean readBooleanAttr(HttpServletRequest req, String attrName) {
        return WebUtil.checkBoolean(attrName, (String)req.getSession().getAttribute(attrName));
    }

    public static String getUsername(HttpServletRequest req, boolean isTesting) throws RuntimeException {
        if (isTesting) {
            return "test";
        }
        Principal prin = req.getUserPrincipal();
        if (prin == null) {
            throw new RuntimeException("Trying to get username but principal object missing. Request is " + req.toString());
        }
        String username = prin.getName();
        if (username == null) {
            throw new RuntimeException("Name missing from principal object. Request is " + req.toString() + " Principal object is " + prin.toString());
        }
        return username;
    }

    public static ToolAccessMode readToolAccessModeParam(HttpServletRequest request, String param_mode, boolean optional) {
        String mode = WebUtil.readStrParam(request, param_mode, optional);
        if (mode == null) {
            return null;
        }
        if (mode.equals(ToolAccessMode.AUTHOR.toString())) {
            return ToolAccessMode.AUTHOR;
        }
        if (mode.equals(ToolAccessMode.LEARNER.toString())) {
            return ToolAccessMode.LEARNER;
        }
        if (mode.equals(ToolAccessMode.TEACHER.toString())) {
            return ToolAccessMode.TEACHER;
        }
        throw new IllegalArgumentException("[" + mode + "] is not a legal modein LAMS");
    }

    public static ToolAccessMode getToolAccessMode(String modeValue) {
        if (modeValue != null) {
            if (modeValue.equals(ToolAccessMode.AUTHOR.toString())) {
                return ToolAccessMode.AUTHOR;
            }
            if (modeValue.equals(ToolAccessMode.LEARNER.toString())) {
                return ToolAccessMode.LEARNER;
            }
            if (modeValue.equals(ToolAccessMode.TEACHER.toString())) {
                return ToolAccessMode.TEACHER;
            }
        }
        throw new IllegalArgumentException("[" + modeValue + "] is not a legal modein LAMS");
    }

    public static ToolAccessMode readToolAccessModeAuthorDefaulted(HttpServletRequest request) {
        String modeStr = request.getParameter("mode");
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    public static String getStrutsForwardNameFromPath(String path) {
        String pathWithoutSlash = StringUtils.substringAfter((String)path, (String)"/");
        String orginalForwardName = StringUtils.substringBeforeLast((String)pathWithoutSlash, (String)".do");
        return StringUtils.uncapitalize((String)orginalForwardName);
    }

    public static String appendParameterToURL(String url, String parameterName, String parameterValue) {
        return WebUtil.appendParameterDeliminator(url) + parameterName + "=" + parameterValue;
    }

    public static String appendParameterDeliminator(String url) {
        if (url == null) {
            return null;
        }
        if (StringUtils.containsNone((String)url, (String)"?")) {
            return url + "?";
        }
        return url + "&";
    }

    public static String convertToFullURL(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("http")) {
            return url;
        }
        String serverURL = Configuration.get(ConfigurationKeys.SERVER_URL);
        if (url.charAt(0) == '/') {
            return serverURL + url;
        }
        return serverURL + '/' + url;
    }

    public static String convertNewlines(String input) {
        if (input != null) {
            return input.replaceAll("[\n\r\f]", "<BR/>");
        }
        return null;
    }

    public static String removeHTMLtags(String text) {
        return text == null ? null : text.replaceAll(SPACE_TAG_REGEX, " ").replaceAll(HTML_TAG_REGEX, "");
    }

    public static InputStream getResponseInputStreamFromExternalServer(String urlStr, HashMap<String, String> params) throws Exception {
        InputStream is;
        if (!urlStr.contains("?")) {
            urlStr = urlStr + "?";
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            urlStr = urlStr + "&" + entry.getKey() + "=" + entry.getValue();
        }
        log.info((Object)("Making request to external servlet: " + urlStr));
        URL url = new URL(urlStr);
        URLConnection conn = url.openConnection();
        if (!(conn instanceof HttpURLConnection)) {
            log.error((Object)("Fail to connect to external server though url:  " + urlStr));
            throw new Exception("Fail to connect to external server though url:  " + urlStr);
        }
        HttpURLConnection httpConn = (HttpURLConnection)conn;
        if (httpConn.getResponseCode() != 200) {
            log.error((Object)("Response code from external server:  " + httpConn.getResponseCode() + " Url: " + urlStr));
        }
        if ((is = url.openConnection().getInputStream()) == null) {
            log.error((Object)("Fail to fetch data from external server, return InputStream null:  " + urlStr));
            throw new Exception("Fail to fetch data from external server, return inputStream null:  " + urlStr);
        }
        return is;
    }

    public static String extractParameterValue(String url, String param) {
        if (!StringUtils.isBlank((String)url) && !StringUtils.isBlank((String)param)) {
            String[] paramEntries;
            int quotationMarkIndex = url.indexOf("?");
            String queryPart = quotationMarkIndex > -1 ? url.substring(quotationMarkIndex + 1) : url;
            for (String paramEntry : paramEntries = queryPart.split("&")) {
                String[] paramEntrySplitted = paramEntry.split("=");
                if (paramEntrySplitted.length <= 1 || !param.equalsIgnoreCase(paramEntrySplitted[0])) continue;
                return paramEntrySplitted[1];
            }
        }
        return null;
    }

    public static JSONObject userToJSON(User user) throws JSONException {
        JSONObject userJSON = new JSONObject();
        userJSON.put("id", (Object)user.getUserId());
        userJSON.put("firstName", (Object)user.getFirstName());
        userJSON.put("lastName", (Object)user.getLastName());
        userJSON.put("login", (Object)user.getLogin());
        userJSON.put("portraitId", (Object)user.getPortraitUuid());
        return userJSON;
    }

    public static String getBaseServerURL() {
        String serverURL = Configuration.get(ConfigurationKeys.SERVER_URL);
        return serverURL.substring(0, serverURL.indexOf(47, 9));
    }

    public static String encodeLessonId(Long lessonId) {
        String encodedLessonId = lessonId.toString();
        encodedLessonId = encodedLessonId.replace('0', URL_SHORTENING_CYPHER.charAt(0));
        encodedLessonId = encodedLessonId.replace('1', URL_SHORTENING_CYPHER.charAt(1));
        encodedLessonId = encodedLessonId.replace('2', URL_SHORTENING_CYPHER.charAt(2));
        encodedLessonId = encodedLessonId.replace('3', URL_SHORTENING_CYPHER.charAt(3));
        encodedLessonId = encodedLessonId.replace('4', URL_SHORTENING_CYPHER.charAt(4));
        encodedLessonId = encodedLessonId.replace('5', URL_SHORTENING_CYPHER.charAt(5));
        encodedLessonId = encodedLessonId.replace('6', URL_SHORTENING_CYPHER.charAt(6));
        encodedLessonId = encodedLessonId.replace('7', URL_SHORTENING_CYPHER.charAt(7));
        encodedLessonId = encodedLessonId.replace('8', URL_SHORTENING_CYPHER.charAt(8));
        encodedLessonId = encodedLessonId.replace('9', URL_SHORTENING_CYPHER.charAt(9));
        return encodedLessonId;
    }

    public static String decodeLessonId(String encodedLessonId) throws IllegalArgumentException {
        if (!encodedLessonId.matches("[jbdnuteywk]*")) {
            throw new IllegalArgumentException("LessonId: " + encodedLessonId + " has wrong format.");
        }
        String decodedLessonId = encodedLessonId;
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(0), '0');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(1), '1');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(2), '2');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(3), '3');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(4), '4');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(5), '5');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(6), '6');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(7), '7');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(8), '8');
        decodedLessonId = decodedLessonId.replace(URL_SHORTENING_CYPHER.charAt(9), '9');
        return decodedLessonId;
    }
}

