/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.audit;

import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;

public class AuditService
implements IAuditService {
    static Logger logger = Logger.getLogger((String)AuditService.class.getName());
    private final String AUDIT_CHANGE_I18N_KEY = "audit.change.entry";
    private final String AUDIT_MARK_CHANGE_I18N_KEY = "audit.change.mark";
    private final String AUDIT_HIDE_I18N_KEY = "audit.hide.entry";
    private final String AUDIT_SHOW_I18N_KEY = "audit.show.entry";
    private final String AUDIT_STARTED_EDITING_I18N_KEY = "audit.started.editing.activity";
    private final String AUDIT_FINISHED_EDITING_I18N_KEY = "audit.finished.editing.activity";
    private final String AUDIT_CANCELLED_EDITING_I18N_KEY = "audit.cancelled.editing.activity";
    protected MessageService messageService;
    protected IActivityDAO activityDao;

    private String getUserString() {
        UserDTO user;
        HttpSession ss = SessionManager.getSession();
        if (ss != null && (user = (UserDTO)ss.getAttribute("user")) != null) {
            return this.getUserString(user);
        }
        return "System Generated (No Current User): ";
    }

    private String getUserString(UserDTO userDTO) {
        return userDTO.getLogin() + "(" + userDTO.getUserID() + "): ";
    }

    @Override
    public void log(String moduleName, String message) {
        logger.info((Object)(this.getUserString() + moduleName + ": " + message));
    }

    @Override
    public void log(UserDTO userDTO, String moduleName, String message) {
        logger.info((Object)(this.getUserString(userDTO) + moduleName + ": " + message));
    }

    @Override
    public void logChange(String moduleName, Long originalUserId, String originalUserLogin, String originalText, String newText) {
        Object[] args = new String[]{originalUserLogin + "(" + originalUserId + ")", originalText, newText};
        String message = this.messageService.getMessage("audit.change.entry", args);
        this.log(moduleName, message);
    }

    @Override
    public void logMarkChange(String moduleName, Long originalUserId, String originalUserLogin, String originalMark, String newMark) {
        Object[] args = new String[]{originalUserLogin + "(" + originalUserId + ")", originalMark, newMark};
        String message = this.messageService.getMessage("audit.change.mark", args);
        this.log(moduleName, message);
    }

    @Override
    public void logHideEntry(String moduleName, Long originalUserId, String originalUserLogin, String hiddenItem) {
        Object[] args = new String[3];
        args[0] = originalUserLogin + "(" + originalUserId + ")";
        args[1] = hiddenItem;
        String message = this.messageService.getMessage("audit.hide.entry", args);
        this.log(moduleName, message);
    }

    @Override
    public void logShowEntry(String moduleName, Long originalUserId, String originalUserLogin, String hiddenItem) {
        Object[] args = new String[3];
        args[0] = originalUserLogin + "(" + originalUserId + ")";
        args[1] = hiddenItem;
        String message = this.messageService.getMessage("audit.show.entry", args);
        this.log(moduleName, message);
    }

    @Override
    public void logStartEditingActivityInMonitor(Long toolContentId) {
        this.logEditActivityInMonitor(toolContentId, "audit.started.editing.activity");
    }

    @Override
    public void logFinishEditingActivityInMonitor(Long toolContentId) {
        this.logEditActivityInMonitor(toolContentId, "audit.finished.editing.activity");
    }

    @Override
    public void logCancelEditingActivityInMonitor(Long toolContentId) {
        this.logEditActivityInMonitor(toolContentId, "audit.cancelled.editing.activity");
    }

    private void logEditActivityInMonitor(Long toolContentId, String messageKey) {
        ToolActivity toolActivity = this.activityDao.getToolActivityByToolContentId(toolContentId);
        String toolSignature = toolActivity.getTool().getToolSignature();
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        Object[] args = new String[]{user.getLogin() + "(" + user.getUserID() + ")", "(activityId:" + toolActivity.getActivityId() + ")"};
        String message = this.messageService.getMessage(messageKey, args);
        this.log(toolSignature, message);
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public IActivityDAO getActivityDao() {
        return this.activityDao;
    }

    public void setActivityDao(IActivityDAO activityDao) {
        this.activityDao = activityDao;
    }
}

