/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util.hibernate;

import javax.servlet.ServletContext;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.context.internal.ManagedSessionContext;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HibernateSessionManager {
    private static SessionFactory sessionFactory;

    public static void openSession() {
        SessionHolder sessionHolder;
        SessionFactory sessionFactory = HibernateSessionManager.getSessionFactory();
        Session session = sessionFactory.getCurrentSession();
        if (!session.isOpen()) {
            ManagedSessionContext.unbind((SessionFactory)sessionFactory);
            TransactionSynchronizationManager.unbindResourceIfPossible((Object)sessionFactory);
            session = sessionFactory.getCurrentSession();
        }
        if ((sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory)) == null) {
            sessionHolder = new SessionHolder(session);
            TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)sessionHolder);
        }
    }

    public static void closeSession() {
        Session session = HibernateSessionManager.getSessionFactory().getCurrentSession();
        if (session.isOpen()) {
            session.close();
        }
    }

    private static SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)SessionManager.getServletContext());
            sessionFactory = (SessionFactory)wac.getBean("coreSessionFactory");
        }
        return sessionFactory;
    }
}

