/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2java;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import net.sf.hibernate.tool.hbm2java.CodeGenerator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Hbm2JavaTask
extends Task {
    private File configurationFile;
    private Path compileClasspath;
    private File outputDir;
    private List filesets = new ArrayList();

    public void setConfig(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void setOutput(File outDirectory) {
        this.outputDir = outDirectory;
    }

    public void execute() throws BuildException {
        List fileList = this.getTargetFiles();
        if (fileList.size() == 0) {
            return;
        }
        this.log("Processing " + fileList.size() + " files.");
        try {
            this.log("Building hibernate objects");
            for (int i = 0; i < fileList.size(); ++i) {
                this.processFile(this.outputDir, (File)fileList.get(i));
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            throw new BuildException("Caused by:\n" + sw.toString());
        }
    }

    private List getTargetFiles() {
        ArrayList<File> l = new ArrayList<File>();
        for (int i = 0; i < this.filesets.size(); ++i) {
            FileSet fs = (FileSet)this.filesets.get(i);
            File parent = fs.getDir(this.getProject());
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                File srcFile = new File(parent, files[j]);
                l.add(srcFile);
            }
        }
        return l;
    }

    private void processFile(File outputDir, File target) {
        ArrayList<String> args = new ArrayList<String>();
        if (outputDir != null) {
            args.add("--output=" + outputDir.getAbsolutePath());
        }
        if (this.configurationFile != null) {
            args.add("--config=" + this.configurationFile);
        }
        args.add(target.getAbsoluteFile().toString());
        try {
            CodeGenerator.main(args.toArray(new String[args.size()]));
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            throw new BuildException("Caused by:\n" + sw.toString());
        }
    }
}

