/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.dao.IBaseDAO;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.GateActivity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.GroupingActivity;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.LearningLibrary;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.ParallelActivity;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.IActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dao.ILearningLibraryDAO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.learningdesign.service.ImportExportUtil;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.tool.SystemTool;
import org.lamsfoundation.lams.tool.Tool;
import org.lamsfoundation.lams.tool.ToolContent;
import org.lamsfoundation.lams.tool.ToolImportSupport;
import org.lamsfoundation.lams.tool.dao.ISystemToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolContentDAO;
import org.lamsfoundation.lams.tool.dao.IToolDAO;
import org.lamsfoundation.lams.tool.dao.IToolImportSupportDAO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.util.wddx.WDDXProcessorConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LD102Importer {
    private static final String MSG_KEY_PERM_GATE = "imported.permission.gate.title";
    private static final String MSG_KEY_SYNC_GATE = "imported.synchronise.gate.title";
    private Logger log = Logger.getLogger(LD102Importer.class);
    private ILearningDesignService learningDesignService = null;
    private MessageService messageService = null;
    private IBaseDAO baseDAO = null;
    private ILearningLibraryDAO learningLibraryDAO = null;
    private ILearningDesignDAO learningDesignDAO = null;
    private IActivityDAO activityDAO = null;
    private IToolDAO toolDAO = null;
    private IToolImportSupportDAO toolImportSupportDAO = null;
    private IToolContentDAO toolContentDAO = null;
    private ISystemToolDAO systemToolDAO = null;
    private LearningDesign ldInProgress = null;
    private Integer maxId = null;
    private String originalPacket = null;
    private List<String> toolsErrorMsgs;
    private Date createDate = new Date();
    private Map<Integer, Integer> groupingsToAssign = new HashMap<Integer, Integer>();
    private Map<Integer, Grouping> newGroupings = new HashMap<Integer, Grouping>();
    private Set<Hashtable> optionalActivitiesToDo = new HashSet<Hashtable>();
    private Set<Hashtable> transitionsToDo = new HashSet<Hashtable>();
    private Map<Integer, Activity> newActivityMap = new HashMap<Integer, Activity>();
    private Map<Integer, Integer> flattenedActivityMap = new HashMap<Integer, Integer>();
    private Map<Integer, Hashtable> contentMap = new HashMap<Integer, Hashtable>();
    private Map<Long, String> libraryActivityUiImages;
    private Map<String, Tool> toolImportSupport;
    private static final Integer NUMERIC_NULL_VALUE_INTEGER = new Integer(-1);
    private static final String LD_OBJECT_TYPE = "LearningDesign";
    private static final String ABSTRACT_TASK_OBJECT_TYPE = "task";
    private static final String MULTI_TASK_OBJECT_TYPE = "Multitask";
    private static final String TRANSITION_OBJECT_TYPE = "transition";
    private static final String ACTIVITY_OBJECT_TYPE = "Activity";
    private static final String OPTIONAL_OBJECT_TYPE = "optionalactivity";
    private static final String CONTENT_OBJECT_TYPE = "content";
    private static final String TOOLDATA_TAGS_TYPE_AUTHORING = "authoring";
    private static final String TOOLDATA_TAGS_JOURNAL = "journal";
    private static final String TOOLDATA_TAGS_NOTICEBOARD = "noticeboard";
    private static final String TOOLDATA_TAGS_MESSAGEBOARD = "messageboard";
    private static final String TOOLDATA_TAGS_LOMS = "loms";
    private static final String TOOLDATA_TAGS_CHAT = "chat";
    private static final String TOOLDATA_TAGS_RPT_SUBMIT = "reportsubmission";
    private static final String TOOLDATA_TAGS_RPT_MARK = "reportmarking";
    private static final String TOOLDATA_TAGS_GROUPING = "group";
    private static final String TOOLDATA_TAGS_GROUPREPORTING = "groupreporting";
    private static final String TOOLDATA_TAGS_RANKING = "ranking";
    private static final String TOOLDATA_TAGS_QUESTIONANSWER = "qa";
    private static final String TOOLDATA_TAGS_SIMPLE_ASSESSMENT = "simpleassessment";
    private static final String TOOLDATA_TAGS_URLCONTENT = "urlcontent";
    private static final String TOOLDATA_TAGS_FILECONTENT = "filecontent";
    private static final String TOOLDATA_TAGS_HTMLNOTICBOARD = "htmlnb";
    private static final String TOOLDATA_TAGS_SINGLE_RESOURCE = "singleresource";
    private static final String TOOLDATA_TAGS_IMAGEGALLERY = "imagegallery";
    private static final String TOOLDATA_TAGS_IMAGERANKING = "imageranking";

    public LD102Importer(ILearningDesignService learningDesignService, MessageService messageService, IBaseDAO baseDAO, ILearningDesignDAO learningDesignDAO, ILearningLibraryDAO learningLibraryDAO, IActivityDAO activityDAO, IToolDAO toolDAO, IToolImportSupportDAO toolImportSupportDAO, IToolContentDAO toolContentDAO, ISystemToolDAO systemToolDAO, List<String> toolsErrorMsgs) {
        this.learningDesignService = learningDesignService;
        this.messageService = messageService;
        this.baseDAO = baseDAO;
        this.learningLibraryDAO = learningLibraryDAO;
        this.learningDesignDAO = learningDesignDAO;
        this.activityDAO = activityDAO;
        this.toolDAO = toolDAO;
        this.systemToolDAO = systemToolDAO;
        this.toolImportSupportDAO = toolImportSupportDAO;
        this.toolContentDAO = toolContentDAO;
        this.toolsErrorMsgs = toolsErrorMsgs;
        if (toolsErrorMsgs == null) {
            this.log.warn((Object)"The list toolsErrorMsgs supplied is null so any warnings will be logged but won't appear in the user's screen.");
            toolsErrorMsgs = new ArrayList<String>();
        }
        this.libraryActivityUiImages = this.getLibraryActivityUiImages();
        this.toolImportSupport = this.getToolImportSupport();
    }

    public void setLearningDesignService(ILearningDesignService learningDesignService) {
        this.learningDesignService = learningDesignService;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setBaseDAO(IBaseDAO baseDAO) {
        this.baseDAO = baseDAO;
    }

    public void setToolDAO(IToolDAO toolDAO) {
        this.toolDAO = toolDAO;
    }

    public void setSystemToolDAO(ISystemToolDAO systemToolDAO) {
        this.systemToolDAO = systemToolDAO;
    }

    public void setToolImportSupportDAO(IToolImportSupportDAO toolImportSupportDAO) {
        this.toolImportSupportDAO = toolImportSupportDAO;
    }

    public void setToolContentDAO(IToolContentDAO toolContentDAO) {
        this.toolContentDAO = toolContentDAO;
    }

    public void setActivityDAO(IActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLearningLibraryDAO(ILearningLibraryDAO learningLibraryDAO) {
        this.learningLibraryDAO = learningLibraryDAO;
    }

    public void setLearningDesignDAO(ILearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }

    private boolean keyExists(Hashtable table, String key) {
        return table.containsKey(key);
    }

    protected static boolean isTask(String objectType) {
        return objectType != null && (objectType.equalsIgnoreCase(ABSTRACT_TASK_OBJECT_TYPE) || objectType.equalsIgnoreCase(MULTI_TASK_OBJECT_TYPE));
    }

    protected static boolean isSimpleTask(String objectType, String toolType) {
        return objectType != null && toolType != null && objectType.equalsIgnoreCase(ABSTRACT_TASK_OBJECT_TYPE) && !toolType.equalsIgnoreCase(TOOLDATA_TAGS_GROUPING);
    }

    protected static boolean isMultiTask(String objectType, String toolType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(MULTI_TASK_OBJECT_TYPE);
    }

    protected static boolean isGroupingToolTask(String objectType, String toolType) {
        return objectType != null && toolType != null && objectType.equalsIgnoreCase(ABSTRACT_TASK_OBJECT_TYPE) && toolType.equalsIgnoreCase(TOOLDATA_TAGS_GROUPING);
    }

    protected static boolean isTransition(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(TRANSITION_OBJECT_TYPE);
    }

    protected static boolean isActivity(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(ACTIVITY_OBJECT_TYPE);
    }

    protected static boolean isOptionalActivity(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(OPTIONAL_OBJECT_TYPE);
    }

    protected static boolean isContent(String objectType) {
        return objectType == null ? false : objectType.equalsIgnoreCase(CONTENT_OBJECT_TYPE);
    }

    protected static boolean isLearningDesign(String objectType) {
        return objectType == null ? false : objectType.trim().equalsIgnoreCase(LD_OBJECT_TYPE);
    }

    protected static String getExpectedActivityTransition() {
        return "Wrong format for data - object type expected isActivity or optionalactivity or transition";
    }

    protected static String getExpectedActivity() {
        return "Wrong format for data - object type expected isActivity";
    }

    protected static String getExpectedOptionalActivity() {
        return "Wrong format for data - object type expected isoptionalactivity";
    }

    protected static String getExpectedContent() {
        return "Wrong format for data - object type expected iscontent";
    }

    protected static String getExpectedTaskTransition() {
        return "Wrong format for data - object type expected istask or Multitask or transition";
    }

    protected static String getExpectedTask() {
        return "Wrong format for data - object type expected istask or Multitask";
    }

    private String getValue(String possValue) {
        return possValue == null ? "" : possValue;
    }

    private boolean containsNulls(String packet) {
        return packet.indexOf("<null />") != -1;
    }

    public Long storeLDDataWDDX(String ldWddxPacket, User importer, WorkspaceFolder folder) throws ImportToolContentException {
        this.originalPacket = ldWddxPacket;
        if (importer == null) {
            throw new ImportToolContentException("Importer is missing");
        }
        if (this.containsNulls(ldWddxPacket)) {
            this.log.error((Object)"Unable to process WDDX packet from client due to containing '<null/>' - this would cause WDDX to crash.");
            this.log.error((Object)("Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid packet format - contains nulls. See log for details.");
        }
        if (!ldWddxPacket.startsWith("<wddxPacket")) {
            this.log.debug((Object)"Packet is probably encrypting. Attempting to decrypt.");
            try {
                ldWddxPacket = ImportExportUtil.decryptImport(ldWddxPacket);
            }
            catch (GeneralSecurityException e) {
                this.log.error((Object)"Unable to decrypt packet", (Throwable)e);
                throw new ImportToolContentException("Invalid packet format - failed decryption. See log for details.", e);
            }
        }
        Hashtable ldHashTable = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Request received to import 1.0.x learning design data" + ldWddxPacket));
        }
        try {
            ldHashTable = (Hashtable)WDDXProcessor.deserialize(ldWddxPacket);
        }
        catch (Exception e) {
            this.log.error((Object)"Unable to process the imported packet: ", (Throwable)e);
            this.log.error((Object)("Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid import data format - unable to deserialise packet. See log for details.");
        }
        if (ldHashTable == null) {
            this.log.error((Object)("WDDX packet is empty. Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid packet format - no details in packet. See log for details.");
        }
        if (LD102Importer.isLearningDesign((String)ldHashTable.get("objectType"))) {
            this.processLearningDesign(ldHashTable, importer, folder);
            Vector<ValidationErrorDTO> listOfValidationErrorDTOs = this.learningDesignService.validateLearningDesign(this.ldInProgress);
            if (listOfValidationErrorDTOs.size() > 0) {
                this.ldInProgress.setValidDesign(Boolean.FALSE);
                this.log.info((Object)("Imported learning design is invalid. New learning design id " + this.ldInProgress.getLearningDesignId() + " title "));
                for (ValidationErrorDTO dto : listOfValidationErrorDTOs) {
                    this.log.info((Object)("Learning design id " + this.ldInProgress.getLearningDesignId() + " validation error " + dto));
                }
            } else {
                this.ldInProgress.setValidDesign(Boolean.TRUE);
            }
        } else {
            this.log.error((Object)("Packet is not a learning design packet. Packet was " + ldWddxPacket));
            throw new ImportToolContentException("Invalid packet format - it is not a learning design packet. See log for details.");
        }
        this.baseDAO.update(this.ldInProgress);
        return this.ldInProgress != null ? this.ldInProgress.getLearningDesignId() : null;
    }

    private void handleWDDXProcessorConversionException(WDDXProcessorConversionException e) {
        this.log.error((Object)"Unable to process the imported packet properly due to a WDDXProcessorConversionException - will continue with the design in case future parts okay.", (Throwable)e);
        this.log.error((Object)("Packet was " + this.originalPacket));
        this.toolsErrorMsgs.add("Invalid import data format - WDDX caused an exception. Some data from the design will have been lost. See log for more details.");
    }

    private void processLearningDesign(Hashtable newLdHashTable, User importer, WorkspaceFolder folder) {
        Vector newActivitiesTransitions;
        this.createLearningDesign(newLdHashTable, importer, folder);
        this.baseDAO.insert(this.ldInProgress);
        Vector newContent = (Vector)newLdHashTable.get(CONTENT_OBJECT_TYPE);
        if (newContent != null) {
            this.processContent(newContent);
        }
        if ((newActivitiesTransitions = (Vector)newLdHashTable.get("activitiesTransitions")) == null) {
            this.log.warn((Object)("No activities or transitions were found for  #" + this.ldInProgress.getLearningDesignId()));
        } else {
            this.processActivitiesTransitions(newActivitiesTransitions);
        }
        for (Hashtable optionTable : this.optionalActivitiesToDo) {
            this.setupOptionalActivity(optionTable);
        }
        this.ldInProgress.setFirstActivity(this.ldInProgress.calculateFirstActivity());
        this.ldInProgress.setMaxID(this.maxId);
        for (Hashtable transTable : this.transitionsToDo) {
            this.setupTransition(transTable);
        }
        this.assignGroupings();
        this.baseDAO.update(this.ldInProgress);
    }

    private void createLearningDesign(Hashtable newLdHashTable, User importer, WorkspaceFolder folder) {
        LearningDesign ld = new LearningDesign();
        ld.setLearningDesignId(null);
        ld.setLearningDesignUIID(null);
        ld.setDescription((String)newLdHashTable.get("description"));
        String title = (String)newLdHashTable.get("title");
        ld.setTitle(ImportExportUtil.generateUniqueLDTitle(folder, title, this.learningDesignDAO));
        ld.setHelpText((String)newLdHashTable.get("helpText"));
        ld.setValidDesign(Boolean.FALSE);
        ld.setReadOnly(Boolean.FALSE);
        ld.setDateReadOnly(null);
        ld.setOfflineInstructions(null);
        ld.setOnlineInstructions(null);
        try {
            this.maxId = WDDXProcessor.convertToInt("Max ID", newLdHashTable.get("maxId"));
            ld.setMaxID(this.maxId);
        }
        catch (WDDXProcessorConversionException e) {
            this.handleWDDXProcessorConversionException(e);
        }
        ld.setUser(importer);
        if (folder != null) {
            ld.setWorkspaceFolder(folder);
        }
        ld.setCopyTypeID(1);
        ld.setCreateDateTime(this.createDate);
        ld.setLastModifiedDateTime(this.createDate);
        ld.setVersion((String)newLdHashTable.get("lamsVersion"));
        ld.setLastModifiedDateTime(this.createDate);
        ld.setDuration(null);
        ld.setLicenseText(null);
        ld.setLicense(null);
        ld.setLessonOrgID(null);
        ld.setLessonOrgName(null);
        ld.setLessonID(null);
        ld.setLessonName(null);
        ld.setLessonStartDateTime(null);
        this.ldInProgress = ld;
    }

    protected void processActivitiesTransitions(List newActivitiesTransitions) {
        for (Hashtable clientObj : newActivitiesTransitions) {
            String objectType = (String)clientObj.get("objectType");
            if (!(LD102Importer.isActivity(objectType) || LD102Importer.isTransition(objectType) || LD102Importer.isOptionalActivity(objectType))) {
                String message = LD102Importer.getExpectedActivityTransition() + " received " + objectType + ". The matching activity/transition will be skipped. Object is " + clientObj;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
            try {
                Integer objId = WDDXProcessor.convertToInteger("Activity/Transition ID", clientObj.get("id"));
                if (NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                    String message = "Id value for activity/transition is internal null value. The activity/transition may not appear in the correct place in the sequence. Activity/transition is " + clientObj;
                    this.log.warn((Object)message);
                    this.toolsErrorMsgs.add(message);
                }
                if (LD102Importer.isActivity(objectType)) {
                    this.processActivity(clientObj, objId);
                    continue;
                }
                if (LD102Importer.isOptionalActivity(objectType)) {
                    this.optionalActivitiesToDo.add(clientObj);
                    continue;
                }
                this.transitionsToDo.add(clientObj);
            }
            catch (WDDXProcessorConversionException e) {
                this.handleWDDXProcessorConversionException(e);
            }
        }
    }

    private void processActivity(Hashtable activityDetails, Integer activityUIID) throws WDDXProcessorConversionException {
        Long nextTransition = WDDXProcessor.convertToLong(activityDetails, "nextTransition");
        Integer xCoOrd = WDDXProcessor.convertToInteger(activityDetails, "x");
        Integer yCoOrd = WDDXProcessor.convertToInteger(activityDetails, "y");
        String title = WDDXProcessor.convertToString(activityDetails, "title");
        String description = WDDXProcessor.convertToString(activityDetails, "description");
        List taskTransitions = (List)activityDetails.get("tasksTransitions");
        if (taskTransitions.size() == 1) {
            Hashtable task = (Hashtable)taskTransitions.get(0);
            this.createActivityFromTask(task, nextTransition, xCoOrd, yCoOrd, activityUIID, title, description);
        } else if (taskTransitions.size() == 3) {
            this.createReflectiveActivity(activityDetails, activityUIID, nextTransition, xCoOrd, yCoOrd, title, description, taskTransitions);
        } else {
            String message = "Unexpected activity format for activity " + title + " expect either 1 or 3 tasks within an activity. This activity will be missing from the sequence. Activity " + activityDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
    }

    private Activity createReflectiveActivity(Hashtable activityDetails, Integer activityUIID, Long nextTransition, Integer xCoOrd, Integer yCoOrd, String title, String description, List taskTransitions) throws WDDXProcessorConversionException {
        String message;
        Activity realTask = null;
        Activity reflectiveTask = null;
        String reflectiveTitle = null;
        String reflectiveDescription = null;
        Integer firstTaskId = WDDXProcessor.convertToInteger(activityDetails, "firstTask");
        if (firstTaskId == null) {
            for (Hashtable task : taskTransitions) {
                if (!LD102Importer.isTransition((String)task.get("objectType"))) continue;
                firstTaskId = WDDXProcessor.convertToInteger(task, "fromTasks");
            }
            if (firstTaskId == null || NUMERIC_NULL_VALUE_INTEGER.equals(firstTaskId)) {
                firstTaskId = null;
                message = "Unable to determine the first task definition in a combined activity " + title + ". This activity will be missing from the sequence. Activity " + activityDetails;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
                return null;
            }
            message = "First task definition missing from activity " + title + ". Guessed it from the rest of the packet. This activity may be incorrect. Activity " + activityDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
        for (Hashtable task : taskTransitions) {
            String objectType = (String)task.get("objectType");
            String toolType = (String)task.get("toolType");
            if (LD102Importer.isTransition(objectType)) continue;
            Integer taskId = WDDXProcessor.convertToInteger(task, "id");
            if (firstTaskId.equals(taskId)) {
                realTask = this.createActivityFromTask(task, nextTransition, xCoOrd, yCoOrd, activityUIID, title, description);
                Integer outputContentTaskId = null;
                if (LD102Importer.isMultiTask(objectType, toolType)) {
                    outputContentTaskId = WDDXProcessor.convertToInteger(task, "outputContentTask");
                    ComplexActivity cActivity = (ComplexActivity)realTask;
                    if (outputContentTaskId != null && !NUMERIC_NULL_VALUE_INTEGER.equals(outputContentTaskId)) {
                        Iterator actIter = cActivity.getActivities().iterator();
                        while (reflectiveTask == null && actIter.hasNext()) {
                            Activity subActivity = (Activity)actIter.next();
                            if (!outputContentTaskId.equals(subActivity.getActivityUIID())) continue;
                            reflectiveTask = subActivity;
                        }
                    }
                } else {
                    reflectiveTask = realTask;
                }
                if (reflectiveTask != null) continue;
                String message2 = "Can't find the task in activity " + title + " that should be reflective. The activity will be created but the reflective part will be missing. Task is " + activityDetails;
                this.log.warn((Object)message2);
                this.toolsErrorMsgs.add(message2);
                continue;
            }
            List subTasks = (List)task.get("subTasks");
            Integer journalTaskInputContentId = null;
            if (subTasks != null) {
                for (Hashtable subTask : subTasks) {
                    if (!TOOLDATA_TAGS_JOURNAL.equals(subTask.get("toolType"))) continue;
                    journalTaskInputContentId = WDDXProcessor.convertToInteger(subTask, "inputContent");
                }
            }
            Hashtable journalContent = null;
            if (journalTaskInputContentId != null && !NUMERIC_NULL_VALUE_INTEGER.equals(journalTaskInputContentId)) {
                journalContent = this.contentMap.get(journalTaskInputContentId);
            }
            if (journalContent != null) {
                reflectiveTitle = (String)journalContent.get("title");
                reflectiveDescription = (String)journalContent.get("body");
                continue;
            }
            String message3 = "Can't find the journal details in the reflective part of " + title + ". The reflective settings in this activity will be missing. Task is " + task;
            this.log.warn((Object)message3);
            this.toolsErrorMsgs.add(message3);
        }
        if (realTask == null) {
            message = "Couldn't find the \"real\" activity inside " + title + ". This activity will be missing from the sequence. Activity " + activityDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        } else if (reflectiveTask == null) {
            message = "Couldn't find \"reflective\" activity inside " + title + ". The reflective settings in this activity will be missing. ";
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        } else {
            message = "Activity " + reflectiveTask.getTitle() + " should be reflective (" + reflectiveTitle + ":" + reflectiveDescription + ") but this isn't supported in the tools yet. To be added when the tools are ready.";
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
        return realTask;
    }

    private Activity createActivityFromTask(Hashtable taskDetails, Long nextTransition, Integer xCoOrd, Integer yCoOrd, Integer parentActivityId, String parentTitle, String parentDescription) throws WDDXProcessorConversionException {
        String objectType = (String)taskDetails.get("objectType");
        String toolType = (String)taskDetails.get("toolType");
        Integer contentId = WDDXProcessor.convertToInteger(taskDetails, "inputContent");
        Activity activity = null;
        Integer taskUIID = null;
        if (this.keyExists(taskDetails, "id")) {
            taskUIID = WDDXProcessor.convertToInteger(taskDetails, "id");
        } else {
            String message = "Id value for task is missing. The activity may not appear in the correct place in the sequence. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
        activity = LD102Importer.isMultiTask(objectType, toolType) ? this.setupParallelActivity(taskDetails, contentId, taskUIID, parentTitle, parentDescription) : (LD102Importer.isGroupingToolTask(objectType, toolType) ? this.setupGroupingActivity(taskDetails, contentId, taskUIID, parentActivityId) : this.setupToolActivity(taskDetails, contentId, taskUIID));
        if (activity != null) {
            this.processCommonActivityFields(taskDetails, xCoOrd, yCoOrd, activity);
            this.newActivityMap.put(activity.getActivityUIID(), activity);
            this.flattenedActivityMap.put(parentActivityId, activity.getActivityUIID());
            this.baseDAO.insert(activity);
        }
        return activity;
    }

    private void processCommonActivityFields(Hashtable taskDetails, Integer xCoOrd, Integer yCoOrd, Activity activity) throws WDDXProcessorConversionException {
        if (activity.getDescription() == null && this.keyExists(taskDetails, "description")) {
            activity.setDescription(WDDXProcessor.convertToString(taskDetails, "description"));
        }
        if (activity.getTitle() == null && this.keyExists(taskDetails, "title")) {
            activity.setTitle(WDDXProcessor.convertToString(taskDetails, "title"));
        }
        activity.setXcoord(xCoOrd);
        activity.setYcoord(yCoOrd);
        activity.setHelpText(null);
        activity.setApplyGrouping(false);
        this.parseGroupingValue(taskDetails.get("grouping"), activity);
        activity.setGroupingSupportType(2);
        activity.setOrderId(null);
        activity.setDefineLater(Boolean.FALSE);
        activity.setLearningDesign(this.ldInProgress);
        activity.setCreateDateTime(this.createDate);
        activity.setRunOffline(Boolean.FALSE);
    }

    private Activity setupParallelActivity(Hashtable taskDetails, Integer contentId, Integer taskUIID, String parentTitle, String parentDescription) throws WDDXProcessorConversionException {
        ParallelActivity activity = (ParallelActivity)Activity.getActivityInstance(6);
        activity.setActivityTypeId(6);
        activity.setActivityCategoryID(1);
        activity.setActivityUIID(taskUIID);
        activity.setDescription(parentDescription);
        activity.setTitle(parentTitle);
        List subTasks = (List)taskDetails.get("subTasks");
        String subTaskOrderString = (String)taskDetails.get("taskOrder");
        if (subTasks == null || subTasks.size() != 2) {
            String message = "Can't find two subtasks for the parallel activity " + parentTitle + ". The parallel activity will not be in the sequence. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
            return null;
        }
        String[] subTaskOrder = subTaskOrderString.split(",");
        int backupUnusedOrderId = subTaskOrder.length;
        for (Hashtable subTask : subTasks) {
            Activity subActivity = this.createActivityFromTask(subTask, null, null, null, null, parentTitle, parentDescription);
            if (subActivity == null) continue;
            subActivity.setParentActivity(activity);
            subActivity.setParentUIID(activity.getActivityUIID());
            activity.addActivity(subActivity);
            Integer orderId = null;
            String subTaskUIID = subActivity.getActivityUIID() != null ? subActivity.getActivityUIID().toString() : "";
            for (int i = 0; orderId == null && i < subTaskOrder.length; ++i) {
                if (!subTaskOrder[i].equals(subTaskUIID)) continue;
                orderId = new Integer(i);
            }
            if (orderId == null) {
                orderId = backupUnusedOrderId++;
                String message = "Order of activities in parallel activity " + parentTitle + " can't be determined properly. The order on the screen may be wrong. Activity is " + taskDetails;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
            subActivity.setOrderId(orderId);
        }
        return activity;
    }

    private GroupingActivity setupGroupingActivity(Hashtable taskDetails, Integer contentId, Integer taskUIID, Integer parentActivityId) throws WDDXProcessorConversionException {
        RandomGrouping grouping = (RandomGrouping)Grouping.getGroupingInstance(Grouping.RANDOM_GROUPING_TYPE);
        grouping.setGroupingUIID(taskUIID);
        this.baseDAO.insert(grouping);
        GroupingActivity groupingActivity = (GroupingActivity)Activity.getActivityInstance(2);
        groupingActivity.setActivityCategoryID(1);
        groupingActivity.setActivityUIID(parentActivityId);
        groupingActivity.setCreateGrouping(grouping);
        groupingActivity.setCreateGroupingUIID(grouping.getGroupingUIID());
        Hashtable groupingContent = this.contentMap.get(contentId);
        if (groupingContent == null) {
            String message = "Unable to find a content for grouping. Default values will apply. Grouping was " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        } else {
            Integer maxNumLearner;
            Integer numGroups = WDDXProcessor.convertToInteger(groupingContent, "number_groups");
            if (numGroups != null && !NUMERIC_NULL_VALUE_INTEGER.equals(numGroups)) {
                grouping.setNumberOfGroups(numGroups);
            }
            if ((maxNumLearner = WDDXProcessor.convertToInteger(groupingContent, "max_number_in_group")) != null && !NUMERIC_NULL_VALUE_INTEGER.equals(maxNumLearner)) {
                grouping.setLearnersPerGroup(maxNumLearner);
            }
            groupingActivity.setTitle((String)groupingContent.get("title"));
            groupingActivity.setDescription((String)groupingContent.get("description"));
        }
        this.newGroupings.put(grouping.getGroupingUIID(), grouping);
        return groupingActivity;
    }

    private ToolActivity setupToolActivity(Hashtable taskDetails, Integer contentId, Integer taskUIID) {
        Tool tool;
        ToolActivity activity = new ToolActivity();
        activity.setActivityUIID(taskUIID);
        activity.setActivityTypeId(1);
        activity.setActivityCategoryID(4);
        String toolType = (String)taskDetails.get("toolType");
        Tool tool2 = tool = toolType != null ? this.toolImportSupport.get(toolType) : null;
        if (tool == null) {
            String message = "Unable to find a tool that supports the activity " + taskDetails.get("title") + ". This activity will be skipped. Activity is " + taskDetails;
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
            return null;
        }
        ToolContent newContent = new ToolContent(tool);
        this.toolContentDAO.saveToolContent(newContent);
        activity.setTool(tool);
        activity.setToolContentId(newContent.getToolContentId());
        activity.setLibraryActivityUiImage(this.libraryActivityUiImages.get(tool.getToolId()));
        return activity;
    }

    private void parseGroupingValue(Object groupingIdRaw, Activity activity) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateGroupingValue: groupingId" + (groupingIdRaw != null ? groupingIdRaw.toString() : "null") + " task " + activity.toString()));
        }
        Integer groupingId = null;
        if (groupingIdRaw != null) {
            try {
                groupingId = WDDXProcessor.convertToInteger("Grouping ID", groupingIdRaw);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (groupingId != null) {
            this.groupingsToAssign.put(activity.getActivityUIID(), groupingId);
            this.log.debug((Object)("Is grouped activity, id=" + groupingId));
        }
    }

    private void assignGroupings() {
        for (Map.Entry<Integer, Integer> entry : this.groupingsToAssign.entrySet()) {
            Activity activity = this.newActivityMap.get(entry.getKey());
            Grouping grouping = this.newGroupings.get(entry.getValue());
            if (activity != null && grouping != null) {
                activity.setGrouping(grouping);
                activity.setGroupingUIID(grouping.getGroupingUIID());
                activity.setApplyGrouping(true);
                continue;
            }
            String message = "Unable to find a pair (activity/grouping) for a grouped activity. The activity will not be grouped. Activity UIID" + entry.getKey() + " grouping UIID " + entry.getValue();
            this.log.warn((Object)message);
            this.toolsErrorMsgs.add(message);
        }
    }

    protected void processContent(List newContent) {
        for (Hashtable clientObj : newContent) {
            String objectType;
            if (clientObj == null) {
                this.log.warn((Object)"Packet contains invalid content - one of the content objects is null!");
                this.log.warn((Object)("Content list is" + newContent.toString()));
                this.toolsErrorMsgs.add("Packet contained an empty content object. See log for more details.");
            }
            if (!LD102Importer.isContent(objectType = (String)clientObj.get("objectType"))) {
                String message = LD102Importer.getExpectedContent() + " received " + objectType + ". The matching activity will be missing its content. Object is " + clientObj;
                this.log.warn((Object)message);
                this.toolsErrorMsgs.add(message);
            }
            try {
                Integer objId = WDDXProcessor.convertToInteger("Content ID", clientObj.get("id"));
                if (NUMERIC_NULL_VALUE_INTEGER.equals(objId)) {
                    String message = "Id value for content is internal null value. The matching activity will be missing its content. Content is " + clientObj;
                    this.log.warn((Object)message);
                    this.toolsErrorMsgs.add(message);
                }
                this.contentMap.put(objId, clientObj);
            }
            catch (WDDXProcessorConversionException e) {
                this.handleWDDXProcessorConversionException(e);
            }
        }
    }

    private void setupOptionalActivity(Hashtable optionObj) {
        try {
            OptionsActivity optionsActivity = (OptionsActivity)Activity.getActivityInstance(7);
            optionsActivity.setActivityCategoryID(1);
            optionsActivity.setActivityUIID(WDDXProcessor.convertToInteger(optionObj, "id"));
            if (this.keyExists(optionObj, "minNumberComplete")) {
                optionsActivity.setMinNumberOfOptions(WDDXProcessor.convertToInteger(optionObj, "minNumberComplete"));
            }
            optionsActivity.setMaxNumberOfOptions(null);
            optionsActivity.setOptionsInstructions(null);
            Integer xCoOrd = WDDXProcessor.convertToInteger(optionObj, "x");
            Integer yCoOrd = WDDXProcessor.convertToInteger(optionObj, "y");
            this.processCommonActivityFields(optionObj, xCoOrd, yCoOrd, optionsActivity);
            Vector subActivityUIIDs = (Vector)optionObj.get("activities");
            int orderId = 1;
            if (subActivityUIIDs != null) {
                Iterator subActIter = subActivityUIIDs.iterator();
                while (subActIter.hasNext()) {
                    Integer id = WDDXProcessor.convertToInteger("Activity ID in Optional Activity", subActIter.next());
                    Activity childActivity = this.getMatchingActivity(id);
                    if (childActivity == null) {
                        String message = "Activity inside optional activity " + optionsActivity.getTitle() + " cannot be matched to a known activity. The child activity will be missing from the optional activity but it may appear in the design elsewhere. Child activity UI ID " + id;
                        this.log.warn((Object)message);
                        this.toolsErrorMsgs.add(message);
                        continue;
                    }
                    optionsActivity.getActivities().add(childActivity);
                    childActivity.setParentActivity(optionsActivity);
                    childActivity.setParentUIID(optionsActivity.getActivityUIID());
                    childActivity.setOrderId(new Integer(orderId++));
                }
            }
            optionsActivity.setLearningDesign(this.ldInProgress);
            this.baseDAO.insert(optionsActivity);
            this.newActivityMap.put(optionsActivity.getActivityUIID(), optionsActivity);
            this.ldInProgress.getActivities().add(optionsActivity);
        }
        catch (WDDXProcessorConversionException e) {
            this.handleWDDXProcessorConversionException(e);
        }
    }

    protected void setupTransition(Hashtable clientObj) {
        try {
            Activity activity;
            Activity activity2;
            Integer toActivity;
            Transition transition = new Transition();
            GateActivity gate = null;
            Transition gateTransition = null;
            transition.setTransitionUIID(WDDXProcessor.convertToInteger("Transition ID", clientObj.get("id")));
            transition.setCreateDateTime(this.createDate);
            String completion = (String)clientObj.get("completionType");
            if (completion != null && completion.length() > 0) {
                gate = this.setupGateActivity(completion);
                gateTransition = new Transition();
                Integer n = this.maxId;
                Integer n2 = this.maxId = Integer.valueOf(this.maxId + 1);
                gateTransition.setTransitionUIID(n);
                gate.setTransitionTo(gateTransition);
                gateTransition.setFromActivity(gate);
                gateTransition.setFromUIID(gate.getActivityUIID());
            }
            if (!NUMERIC_NULL_VALUE_INTEGER.equals(toActivity = WDDXProcessor.convertToInteger("ToTaskActivities", clientObj.get("toTasks"))) && (activity2 = this.getMatchingActivity(toActivity)) != null) {
                if (gate != null) {
                    this.setToActivity(transition, gate);
                    this.setToActivity(gateTransition, activity2);
                    int x = activity2.getXcoord() != null ? activity2.getXcoord() : 0;
                    gate.setXcoord(x >= 20 ? x - 20 : 5);
                    gate.setYcoord(activity2.getYcoord());
                } else {
                    this.setToActivity(transition, activity2);
                }
            }
            if (transition.getToActivity() == null) {
                String msg = "Can't find matching activity " + toActivity + " for transition. Transition will be missing in the design. Transition " + clientObj;
                this.log.error((Object)msg);
                this.toolsErrorMsgs.add(msg);
                return;
            }
            Integer fromActivity = WDDXProcessor.convertToInteger("FromTaskActivities", clientObj.get("fromTasks"));
            if (!NUMERIC_NULL_VALUE_INTEGER.equals(fromActivity) && (activity = this.getMatchingActivity(fromActivity)) != null) {
                transition.setFromUIID(activity.getActivityUIID());
                transition.setFromActivity(activity);
                activity.setTransitionFrom(transition);
            }
            if (transition.getFromActivity() == null) {
                String msg = "Can't find matching activity " + fromActivity + " for transition. Transition will be missing in the design. Transition " + clientObj;
                this.log.error((Object)msg);
                this.toolsErrorMsgs.add(msg);
                return;
            }
            transition.setLearningDesign(this.ldInProgress);
            this.ldInProgress.getTransitions().add(transition);
            this.baseDAO.insert(transition);
            if (gateTransition != null) {
                gateTransition.setLearningDesign(this.ldInProgress);
                this.ldInProgress.getTransitions().add(gateTransition);
                this.baseDAO.insert(gateTransition);
            }
        }
        catch (WDDXProcessorConversionException e) {
            this.handleWDDXProcessorConversionException(e);
        }
    }

    private GateActivity setupGateActivity(String completion) {
        GateActivity gate = null;
        Integer syncType = null;
        SystemTool systemTool = null;
        Integer activityType = null;
        String title = null;
        if ("synchronize".equals(completion)) {
            syncType = new Integer(3);
            systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.SYNC_GATE);
            activityType = new Integer(3);
            title = this.messageService.getMessage(MSG_KEY_SYNC_GATE);
        } else {
            syncType = new Integer(5);
            systemTool = this.systemToolDAO.getSystemToolByID(SystemTool.PERMISSION_GATE);
            activityType = new Integer(5);
            title = this.messageService.getMessage(MSG_KEY_PERM_GATE);
        }
        if (syncType != null) {
            gate = (GateActivity)Activity.getActivityInstance(syncType);
            gate.setActivityTypeId((int)activityType);
            gate.setActivityCategoryID(1);
            gate.setSystemTool(systemTool);
            Integer n = this.maxId;
            Integer n2 = this.maxId = Integer.valueOf(this.maxId + 1);
            gate.setActivityUIID(n);
            gate.setTitle(title != null ? title : "Gate");
            gate.setGateOpen(false);
            gate.setWaitingLearners(null);
            gate.setGateActivityLevelId(1);
            gate.setApplyGrouping(false);
            gate.setGroupingSupportType(2);
            gate.setOrderId(null);
            gate.setDefineLater(Boolean.FALSE);
            gate.setCreateDateTime(this.createDate);
            gate.setRunOffline(Boolean.FALSE);
            gate.setLearningDesign(this.ldInProgress);
            this.ldInProgress.getActivities().add(gate);
            this.baseDAO.insert(gate);
        }
        return gate;
    }

    private void setToActivity(Transition transition, Activity activity) {
        transition.setToUIID(activity.getActivityUIID());
        transition.setToActivity(activity);
        activity.setTransitionTo(transition);
    }

    private Activity getMatchingActivity(Integer uiID) {
        Integer childActivityId;
        Activity activity = this.newActivityMap.get(uiID);
        if (activity == null && (childActivityId = this.flattenedActivityMap.get(uiID)) != null) {
            activity = this.newActivityMap.get(childActivityId);
        }
        return activity;
    }

    private Map<Long, String> getLibraryActivityUiImages() {
        HashMap<Long, String> imageURLS = new HashMap<Long, String>();
        for (LearningLibrary learningLibrary : this.learningLibraryDAO.getAllLearningLibraries()) {
            List templateActivities = this.activityDAO.getActivitiesByLibraryID(learningLibrary.getLearningLibraryId());
            for (Activity activity : templateActivities) {
                ToolActivity toolActivity;
                Tool tool;
                if (!activity.isToolActivity() || imageURLS.containsKey((tool = (toolActivity = (ToolActivity)this.activityDAO.getActivityByActivityId(activity.getActivityId(), ToolActivity.class)).getTool()).getToolId())) continue;
                imageURLS.put(tool.getToolId(), activity.getLibraryActivityUiImage());
            }
        }
        return imageURLS;
    }

    private Map<String, Tool> getToolImportSupport() {
        HashMap<String, Tool> supportedTools = new HashMap<String, Tool>();
        for (ToolImportSupport support : this.toolImportSupportDAO.getAllToolImportSupport()) {
            Tool tool = this.toolDAO.getToolBySignature(support.getInstalledToolSignature());
            if (tool == null || !tool.isValid()) continue;
            supportedTools.put(support.getSupportsToolSignature(), tool);
        }
        return supportedTools;
    }
}

