/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.service;

import java.util.Set;
import java.util.Vector;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.learningdesign.OptionsActivity;
import org.lamsfoundation.lams.learningdesign.Transition;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.ActivityDAO;
import org.lamsfoundation.lams.learningdesign.dao.hibernate.LearningDesignDAO;
import org.lamsfoundation.lams.learningdesign.dto.LearningDesignDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.util.MessageService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LearningDesignService
implements ILearningDesignService {
    protected MessageService messageService;
    protected LearningDesignDAO learningDesignDAO;
    protected ActivityDAO activityDAO;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    @Override
    public LearningDesignDTO getLearningDesignDTO(Long learningDesignID) {
        LearningDesign design = learningDesignID != null ? this.learningDesignDAO.getLearningDesignById(learningDesignID) : null;
        return design != null ? new LearningDesignDTO(design, this.activityDAO) : null;
    }

    @Override
    public Vector<ValidationErrorDTO> validateLearningDesign(LearningDesign learningDesign) {
        Vector<ValidationErrorDTO> listOfValidationErrorDTOs = new Vector<ValidationErrorDTO>();
        this.validateActivityTransitionRules(learningDesign.getParentActivities(), learningDesign.getTransitions(), listOfValidationErrorDTOs);
        this.validateGeneral(learningDesign.getActivities(), listOfValidationErrorDTOs);
        return listOfValidationErrorDTOs;
    }

    private void validateActivityTransitionRules(Set topLevelActivities, Set transitions, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        this.validateTransitions(transitions, listOfValidationErrorDTOs);
        Vector<Activity> noInputTransition = new Vector<Activity>();
        Vector<Activity> noOuputTransition = new Vector<Activity>();
        int numOfTopLevelActivities = topLevelActivities.size();
        for (Activity activity : topLevelActivities) {
            this.checkActivityForTransition(activity, numOfTopLevelActivities, listOfValidationErrorDTOs);
            if (activity.getTransitionFrom() == null) {
                noOuputTransition.add(activity);
            }
            if (activity.getTransitionTo() != null) continue;
            noInputTransition.add(activity);
        }
        if (numOfTopLevelActivities > 0) {
            if (noInputTransition.size() == 0) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.inputTransitionType2")));
            }
            if (noInputTransition.size() > 1) {
                for (Activity a : noInputTransition) {
                    listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.inputTransitionType1"), a.getActivityUIID()));
                }
            }
            if (noOuputTransition.size() == 0) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.outputTransitionType2")));
            }
            if (noOuputTransition.size() > 1) {
                for (Activity a : noOuputTransition) {
                    listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.outputTransitionType1"), a.getActivityUIID()));
                }
            }
        }
    }

    private void validateTransitions(Set transitions, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        for (Transition transition : transitions) {
            Activity fromActivity = transition.getFromActivity();
            Activity toActivity = transition.getToActivity();
            if (fromActivity == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
                continue;
            }
            if (toActivity != null) continue;
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.transitionNoActivityBeforeOrAfter"), transition.getTransitionUIID()));
        }
    }

    private void checkActivityForTransition(Activity activity, int numOfActivities, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        Transition inputTransition = activity.getTransitionTo();
        Transition outputTransition = activity.getTransitionFrom();
        if (numOfActivities > 1 && inputTransition == null && outputTransition == null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
        if (numOfActivities == 1 && (inputTransition != null || outputTransition != null)) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.activityWithNoTransition"), activity.getActivityUIID()));
        }
    }

    private void validateGeneral(Set activities, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        for (Activity activity : activities) {
            this.checkIfGroupingRequired(activity, listOfValidationErrorDTOs);
            this.validateGroupingIfGroupingIsApplied(activity, listOfValidationErrorDTOs);
            this.validateOptionalActivity(activity, listOfValidationErrorDTOs);
            this.validateOptionsActivityOrderId(activity, listOfValidationErrorDTOs);
            Vector<ValidationErrorDTO> activityErrors = activity.validateActivity(this.messageService);
            if (activityErrors == null || activityErrors.isEmpty()) continue;
            listOfValidationErrorDTOs.addAll(activityErrors);
        }
    }

    private void checkIfGroupingRequired(Activity activity, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        Grouping grouping;
        Integer groupingSupportType = activity.getGroupingSupportType();
        if (groupingSupportType == 3) {
            Grouping grouping2 = activity.getGrouping();
            if (grouping2 == null) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.GroupingRequired"), activity.getActivityUIID()));
            }
        } else if (groupingSupportType == 1 && (grouping = activity.getGrouping()) != null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.GroupingNotRequired"), activity.getActivityUIID()));
        }
    }

    private void validateOptionalActivity(Activity parentActivity, Vector<ValidationErrorDTO> listOfValidationErrorDTOs) {
        OptionsActivity optionsActivity;
        Set childActivities;
        int numOfChildActivities;
        if (parentActivity.isOptionsActivity() && (numOfChildActivities = (childActivities = (optionsActivity = (OptionsActivity)parentActivity).getActivities()).size()) == 0) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.OptionalActivity"), optionsActivity.getActivityUIID()));
        }
    }

    private void validateOptionsActivityOrderId(Activity parentActivity, Vector listOfValidationErrorDTOs) {
        Integer thisActivityOrderId = null;
        Integer previousActivityOrderId = null;
        boolean validOrderId = true;
        if (parentActivity.isOptionsActivity()) {
            OptionsActivity optionsActivity = (OptionsActivity)parentActivity;
            Set childActivities = optionsActivity.getActivities();
            for (Activity childActivity : childActivities) {
                thisActivityOrderId = childActivity.getOrderId();
                if (previousActivityOrderId != null) {
                    if (thisActivityOrderId.longValue() != previousActivityOrderId.longValue() + 1L) {
                        if (validOrderId) {
                            // empty if block
                        }
                        validOrderId = false;
                    }
                } else if (thisActivityOrderId.longValue() != 1L) {
                    if (validOrderId) {
                        // empty if block
                    }
                    validOrderId = false;
                }
                previousActivityOrderId = thisActivityOrderId;
            }
            if (!validOrderId) {
                listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage("validation.error.OptionalActivityOrderId"), optionsActivity.getActivityUIID()));
            }
        }
    }

    private void validateGroupingIfGroupingIsApplied(Activity activity, Vector listOfValidationErrorDTOs) {
        if (activity.getApplyGrouping().booleanValue() && activity.getGrouping() == null) {
            listOfValidationErrorDTOs.add(new ValidationErrorDTO(this.messageService.getMessage(ValidationErrorDTO.GROUPING_SELECTED_ERROR), activity.getActivityUIID()));
        }
    }

    public void setActivityDAO(ActivityDAO activityDAO) {
        this.activityDAO = activityDAO;
    }

    public void setLearningDesignDAO(LearningDesignDAO learningDesignDAO) {
        this.learningDesignDAO = learningDesignDAO;
    }
}

