/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class HttpSessionManager {
    private static Logger log = Logger.getLogger(HttpSessionManager.class);
    private static HttpSessionManager realMe = null;
    private static ServletContext context = null;
    private Map HttpSessionsByLogin = Collections.synchronizedMap(new HashMap());
    private int timeout = Configuration.getAsInt(ConfigurationKeys.INACTIVE_TIME);
    private boolean allowMultipleLogin = Configuration.getAsBoolean(ConfigurationKeys.ALLOW_MULTIPLE_LOGIN);

    private HttpSessionManager() {
    }

    public static HttpSessionManager getInstance() {
        if (realMe == null) {
            realMe = new HttpSessionManager();
        }
        return realMe;
    }

    public HttpSession getHttpSessionByLogin(String login) {
        return (HttpSession)this.HttpSessionsByLogin.get(login);
    }

    public void updateHttpSessionByLogin(HttpSession session, String login) {
        if (!this.allowMultipleLogin) {
            if (login == null || session == null) {
                return;
            }
            HttpSession oldSession = (HttpSession)this.HttpSessionsByLogin.get(login);
            if (oldSession != null) {
                if (oldSession.getId().equals(session.getId())) {
                    return;
                }
                try {
                    this.copySessionAttributes(oldSession, session);
                    oldSession.invalidate();
                }
                catch (IllegalStateException e) {
                    // empty catch block
                }
            }
            this.HttpSessionsByLogin.put(login, session);
        }
    }

    private void copySessionAttributes(HttpSession oldSession, HttpSession session) {
        Enumeration enu = oldSession.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            session.setAttribute(name, oldSession.getAttribute(name));
        }
    }

    public ServletContext getServletContext() {
        return context;
    }

    public void sessionCreated(HttpSessionEvent se) {
        Locale preferredLocale;
        if (se == null) {
            return;
        }
        HttpSession session = se.getSession();
        session.setMaxInactiveInterval(this.timeout);
        context = session.getServletContext();
        if (session != null && (preferredLocale = new Locale(Configuration.get(ConfigurationKeys.SERVER_LANGUAGE))) != null) {
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)preferredLocale);
            Config.set((HttpSession)session, (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)preferredLocale);
        }
    }
}

