/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.ClasspathUtils;
import com.tacitknowledge.util.discovery.ResourceListSourceSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArchiveResourceListSource
extends ResourceListSourceSupport {
    protected String[] getResources(String basePath) {
        String root = basePath == null ? "" : basePath;
        root = root.replace('\\', '/');
        ArrayList resourceNames = new ArrayList();
        List jars = this.getJars();
        for (String jarName : jars) {
            try {
                ZipFile file = new ZipFile(jarName);
                resourceNames.addAll(this.getResources(file, root));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return resourceNames.toArray(new String[resourceNames.size()]);
    }

    protected List getJars() {
        return ClasspathUtils.getClasspathArchives();
    }

    private List getResources(ZipFile file, String root) {
        ArrayList<String> resourceNames = new ArrayList<String>();
        Enumeration<? extends ZipEntry> e = file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.startsWith(root) || name.indexOf(47) > root.length() || entry.isDirectory()) continue;
            name = new File(name).getPath();
            resourceNames.add(name);
        }
        return resourceNames;
    }
}

