/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.ResourceCriteria;
import java.io.File;
import java.lang.reflect.Modifier;

public class ClassCriteria
implements ResourceCriteria {
    private Class[] interfaces = null;

    public ClassCriteria(Class c) {
        this(new Class[]{c});
    }

    public ClassCriteria(Class[] interfaces) {
        this.interfaces = interfaces;
    }

    public boolean matches(String resourceName) {
        if (resourceName.endsWith(".class")) {
            String className = resourceName.substring(0, resourceName.length() - 6);
            className = className.replace(File.separatorChar, '.');
            try {
                Class<?> c = Class.forName(className);
                boolean isRightType = this.isConcrete(c);
                int i = 0;
                while (isRightType && i < this.interfaces.length) {
                    Class interfaceClass = this.interfaces[i];
                    if (!interfaceClass.isAssignableFrom(c)) {
                        isRightType = false;
                    }
                    ++i;
                }
                return isRightType;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private boolean isConcrete(Class c) {
        return !c.isInterface() && !Modifier.isAbstract(c.getModifiers());
    }
}

