/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ClasspathUtils {
    private static Log log = LogFactory.getLog(ClasspathUtils.class);

    private ClasspathUtils() {
    }

    public static List getClasspathDirectories() {
        ArrayList<String> directories = new ArrayList<String>();
        List components = ClasspathUtils.getClasspathComponents();
        for (String possibleDir : components) {
            File file = new File(possibleDir);
            if (!file.isDirectory()) continue;
            directories.add(possibleDir);
        }
        List tomcatPaths = ClasspathUtils.getTomcatPaths();
        if (tomcatPaths != null) {
            directories.addAll(tomcatPaths);
        }
        return directories;
    }

    public static List getClasspathArchives() {
        ArrayList<String> archives = new ArrayList<String>();
        List components = ClasspathUtils.getClasspathComponents();
        for (String possibleDir : components) {
            File file = new File(possibleDir);
            if (!file.isFile() || !file.getName().endsWith(".jar") && !file.getName().endsWith(".zip")) continue;
            archives.add(possibleDir);
        }
        return archives;
    }

    public static List getClasspathComponents() {
        LinkedList<String> components = new LinkedList<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        while (cl != null && cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            components.addAll(ClasspathUtils.getUrlClassLoaderClasspathComponents(ucl));
            try {
                cl = ucl.getParent();
            }
            catch (SecurityException se) {
                cl = null;
            }
        }
        String classpath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(classpath, separator);
        while (st.hasMoreTokens()) {
            String component = st.nextToken();
            component = ClasspathUtils.getCanonicalPath(component);
            components.add(component);
        }
        return new LinkedList(new HashSet(components));
    }

    public static String getCanonicalPath(String path) {
        File file = new File(path);
        String canonicalPath = null;
        if (file.exists()) {
            try {
                canonicalPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                log.warn((Object)("Error resolving filename to canonical file: " + e.toString()));
            }
        }
        if (canonicalPath == null) {
            canonicalPath = file.getPath();
        }
        return canonicalPath;
    }

    private static List getUrlClassLoaderClasspathComponents(URLClassLoader ucl) {
        ArrayList<String> components = new ArrayList<String>();
        URL[] urls = new URL[]{};
        if (ucl.getClass().getName().equals("org.jboss.mx.loading.UnifiedClassLoader3")) {
            try {
                Method classPathMethod = ucl.getClass().getMethod("getClasspath", new Class[0]);
                urls = (URL[])classPathMethod.invoke((Object)ucl, new Object[0]);
            }
            catch (Exception e) {
                LogFactory.getLog(ClasspathUtils.class).debug((Object)"Error invoking getClasspath on UnifiedClassLoader3: ", (Throwable)e);
            }
        } else {
            urls = ucl.getURLs();
        }
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            components.add(ClasspathUtils.getCanonicalPath(url.getPath()));
            ++i;
        }
        return components;
    }

    private static List getTomcatPaths() {
        String tomcatPath = System.getProperty("catalina.home");
        if (tomcatPath == null) {
            return null;
        }
        String commonClasspath = System.getProperty("common.loader");
        if (commonClasspath == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(commonClasspath);
        String pathDeclaration = "${catalina.home}";
        int length = pathDeclaration.length();
        boolean doneReplace = false;
        do {
            int start;
            if ((start = commonClasspath.indexOf(pathDeclaration)) >= 0) {
                buffer.replace(start, start + length, tomcatPath);
                commonClasspath = buffer.toString();
                continue;
            }
            doneReplace = true;
        } while (!doneReplace);
        String[] paths = commonClasspath.split(",");
        ArrayList<String> pathList = new ArrayList<String>(paths.length);
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            pathList.add(ClasspathUtils.getCanonicalPath(path));
            ++i;
        }
        return pathList;
    }
}

