/*
 * Decompiled with CFR 0.152.
 */
package com.tacitknowledge.util.discovery;

import com.tacitknowledge.util.discovery.ClasspathUtils;
import com.tacitknowledge.util.discovery.DirectoryFilter;
import com.tacitknowledge.util.discovery.ResourceListSourceSupport;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class DirectoryResourceListSource
extends ResourceListSourceSupport {
    private FileFilter directoryFilter = new DirectoryFilter();

    protected String[] getResources(String basePath) {
        String root = basePath == null ? "" : basePath;
        ArrayList<String> resourceNames = new ArrayList<String>();
        List directories = this.getDirectories();
        for (String cpDirName : directories) {
            String dirName = null;
            dirName = root.startsWith(File.separator) || cpDirName.endsWith(File.separator) ? String.valueOf(cpDirName) + root : String.valueOf(cpDirName) + File.separatorChar + root;
            File dir = new File(dirName);
            if (!dir.exists() || !dir.isDirectory()) continue;
            File[] files = dir.listFiles(this.directoryFilter);
            int j = 0;
            while (j < files.length) {
                String fileName = files[j].getName();
                String resourceName = String.valueOf(root) + File.separator + fileName;
                resourceName = new File(resourceName).getPath();
                resourceNames.add(resourceName);
                ++j;
            }
        }
        return resourceNames.toArray(new String[resourceNames.size()]);
    }

    protected List getDirectories() {
        return ClasspathUtils.getClasspathDirectories();
    }
}

