/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.jboss.logging.Logger;

public class RequestDumperValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.RequestDumperValve/1.0";
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.valves");

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        Logger log = this.container.getLogger();
        log.info((Object)("REQUEST URI       =" + request.getRequestURI()));
        log.info((Object)("          authType=" + request.getAuthType()));
        log.info((Object)(" characterEncoding=" + request.getCharacterEncoding()));
        log.info((Object)("     contentLength=" + request.getContentLength()));
        log.info((Object)("       contentType=" + request.getContentType()));
        log.info((Object)("       contextPath=" + request.getContextPath()));
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                log.info((Object)("            cookie=" + cookies[i].getName() + "=" + cookies[i].getValue()));
            }
        }
        Enumeration hnames = request.getHeaderNames();
        while (hnames.hasMoreElements()) {
            String hname = (String)hnames.nextElement();
            Enumeration hvalues = request.getHeaders(hname);
            while (hvalues.hasMoreElements()) {
                String hvalue = (String)hvalues.nextElement();
                log.info((Object)("            header=" + hname + "=" + hvalue));
            }
        }
        log.info((Object)("            locale=" + request.getLocale()));
        log.info((Object)("            method=" + request.getMethod()));
        Enumeration pnames = request.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            String[] pvalues = request.getParameterValues(pname);
            StringBuffer result = new StringBuffer(pname);
            result.append('=');
            for (int i = 0; i < pvalues.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(pvalues[i]);
            }
            log.info((Object)("         parameter=" + result.toString()));
        }
        log.info((Object)("          pathInfo=" + request.getPathInfo()));
        log.info((Object)("          protocol=" + request.getProtocol()));
        log.info((Object)("       queryString=" + request.getQueryString()));
        log.info((Object)("        remoteAddr=" + request.getRemoteAddr()));
        log.info((Object)("        remoteHost=" + request.getRemoteHost()));
        log.info((Object)("        remoteUser=" + request.getRemoteUser()));
        log.info((Object)("requestedSessionId=" + request.getRequestedSessionId()));
        log.info((Object)("            scheme=" + request.getScheme()));
        log.info((Object)("        serverName=" + request.getServerName()));
        log.info((Object)("        serverPort=" + request.getServerPort()));
        log.info((Object)("       servletPath=" + request.getServletPath()));
        log.info((Object)("          isSecure=" + request.isSecure()));
        log.info((Object)"---------------------------------------------------------------");
        this.getNext().invoke(request, response);
        log.info((Object)"---------------------------------------------------------------");
        log.info((Object)("          authType=" + request.getAuthType()));
        log.info((Object)("     contentLength=" + response.getContentLength()));
        log.info((Object)("       contentType=" + response.getContentType()));
        Cookie[] rcookies = response.getCookies();
        for (int i = 0; i < rcookies.length; ++i) {
            log.info((Object)("            cookie=" + rcookies[i].getName() + "=" + rcookies[i].getValue() + "; domain=" + rcookies[i].getDomain() + "; path=" + rcookies[i].getPath()));
        }
        String[] rhnames = response.getHeaderNames();
        for (int i = 0; i < rhnames.length; ++i) {
            String[] rhvalues = response.getHeaderValues(rhnames[i]);
            for (int j = 0; j < rhvalues.length; ++j) {
                log.info((Object)("            header=" + rhnames[i] + "=" + rhvalues[j]));
            }
        }
        log.info((Object)("           message=" + response.getMessage()));
        log.info((Object)("        remoteUser=" + request.getRemoteUser()));
        log.info((Object)("            status=" + response.getStatus()));
        log.info((Object)"===============================================================");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestDumperValve[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }
}

