/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.util;

import com.allaire.util.ObjectConversionException;
import java.lang.reflect.Array;
import java.util.Vector;

public class ObjectConverter {
    private ObjectConverter() {
    }

    public static Object convert(Object value, Class type) throws ObjectConversionException {
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof Double) {
            value = ObjectConverter.convert((Double)value, type);
        } else if (value instanceof String) {
            value = ObjectConverter.convert((String)value, type);
        } else if (value instanceof Vector) {
            value = ObjectConverter.convert((Vector)value, type);
        }
        return value;
    }

    private static Object convert(Double value, Class type) throws ObjectConversionException {
        try {
            if (type == Integer.TYPE || type.equals(Integer.class)) {
                return new Integer(value.intValue());
            }
            if (type == Long.TYPE || type.equals(Long.class)) {
                return new Long(value.longValue());
            }
            if (type == Float.TYPE || type.equals(Float.class)) {
                return new Float(value.floatValue());
            }
            if (type == Double.TYPE || type.equals(Double.class)) {
                return new Double(value);
            }
            if (type == Short.TYPE || type.equals(Short.class)) {
                return new Short(value.shortValue());
            }
        }
        catch (Exception e) {
            throw new ObjectConversionException("Failed to convert Double to type:" + type.getName(), e);
        }
        throw new ObjectConversionException("Failed to convert Double to type:" + type.getName());
    }

    private static Object convert(String value, Class type) throws ObjectConversionException {
        try {
            if (type == Integer.TYPE || type.equals(Integer.class)) {
                return new Integer(value);
            }
            if (type == Long.TYPE || type.equals(Long.class)) {
                return new Long(value);
            }
            if (type == Float.TYPE || type.equals(Float.class)) {
                return new Float(value);
            }
            if (type == Double.TYPE || type.equals(Double.class)) {
                return new Double(value);
            }
            if (type == Short.TYPE || type.equals(Short.class)) {
                return new Short(value);
            }
            if (type == Character.TYPE || type.equals(Character.class)) {
                if (value.length() != 1) {
                    throw new ObjectConversionException("Can't convert String to char: " + value);
                }
                return new Character(value.charAt(0));
            }
            if (type == Boolean.TYPE || type.equals(Boolean.class)) {
                return new Boolean(value);
            }
        }
        catch (Exception e) {
            throw new ObjectConversionException("Failed to convert String to type:" + type.getName(), e);
        }
        throw new ObjectConversionException("Failed to convert String to type:" + type.getName());
    }

    private static Object convert(Vector value, Class type) throws ObjectConversionException {
        try {
            if (type.isArray()) {
                Class elementType = ObjectConverter.getClassBySignature(type.getName().substring(1));
                int size = value.size();
                Object array = Array.newInstance(elementType, size);
                for (int i = 0; i < size; ++i) {
                    Array.set(array, i, ObjectConverter.convert(value.elementAt(i), elementType));
                }
                return array;
            }
        }
        catch (Exception e) {
            throw new ObjectConversionException("Failed to convert Vector to type:" + type.getName(), e);
        }
        throw new ObjectConversionException("Failed to convert Vector to type:" + type.getName());
    }

    private static Class getClassBySignature(String jniTypeSig) throws ClassNotFoundException {
        int index = 0;
        char c = jniTypeSig.charAt(index);
        switch (c) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            default: {
                String className = jniTypeSig.substring(index + 1, jniTypeSig.length() - 1);
                return Class.forName(className);
            }
            case '[': 
        }
        String className = jniTypeSig.substring(index, jniTypeSig.length());
        return Class.forName(className);
    }
}

