/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import java.util.Vector;
import org.xml.sax.AttributeList;

class ArrayHandler
extends WddxElement {
    private static final String LENGTH_ATTRIBUTE_NAME = "length";
    private Vector m_array = null;

    ArrayHandler() {
    }

    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        String length = attributes.getValue(LENGTH_ATTRIBUTE_NAME);
        if (length == null) {
            this.throwException("Array element does not have a length attribute.");
        }
        try {
            this.m_array = new Vector(Integer.parseInt(length));
        }
        catch (NumberFormatException e) {
            this.throwException("The length attribute is not an integer", e);
        }
    }

    public void onEndElement() throws WddxDeserializationException {
        this.setValue(this.m_array);
    }

    public void onAfterChild(WddxElement childElement) throws WddxDeserializationException {
        this.m_array.addElement(childElement.getValue());
    }
}

