/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxObjectSerializer;
import com.allaire.wddx.WddxOutputStream;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;

class BeanSerializer
implements WddxObjectSerializer {
    BeanSerializer() {
    }

    public void writeObject(WddxOutputStream out, Object obj) throws IOException {
        block18: {
            Class<?> cls = obj.getClass();
            try {
                if (cls.isArray()) {
                    Object[] array = (Object[])obj;
                    out.writeArrayBegin(array.length);
                    for (int i = 0; i < array.length; ++i) {
                        out.writeObject(array[i]);
                    }
                    out.writeArrayEnd();
                    break block18;
                }
                BeanInfo binfo = Introspector.getBeanInfo(cls, Object.class);
                PropertyDescriptor[] descriptors = binfo.getPropertyDescriptors();
                out.writeStructBegin(BeanSerializer.getTypeSignature(obj.getClass()));
                for (int i = 0; i < descriptors.length; ++i) {
                    PropertyDescriptor pd = descriptors[i];
                    String name = pd.getName();
                    try {
                        Object value;
                        if (pd instanceof IndexedPropertyDescriptor) {
                            Vector<Object> values;
                            block19: {
                                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                                values = new Vector<Object>();
                                Method getter = ipd.getIndexedReadMethod();
                                try {
                                    getter.setAccessible(true);
                                }
                                catch (Error e) {
                                    // empty catch block
                                }
                                if (getter == null) continue;
                                try {
                                    int index = 0;
                                    while (true) {
                                        Object value2 = getter.invoke(obj, new Integer(index));
                                        values.addElement(value2);
                                        ++index;
                                    }
                                }
                                catch (IllegalAccessException e) {
                                }
                                catch (InvocationTargetException e) {
                                    if (e.getTargetException() instanceof IndexOutOfBoundsException) break block19;
                                    throw new IOException("Error reading property " + cls.getName() + "." + name + ": " + e.getTargetException().getMessage());
                                }
                            }
                            int size = values.size();
                            out.writeVarBegin(name);
                            out.writeArrayBegin(size);
                            for (int index = 0; index < size; ++index) {
                                out.writeObject(values.elementAt(index));
                            }
                            out.writeArrayEnd();
                            out.writeVarEnd();
                            continue;
                        }
                        Method getter = pd.getReadMethod();
                        try {
                            getter.setAccessible(true);
                        }
                        catch (Error e) {
                            // empty catch block
                        }
                        if (getter == null || (value = getter.invoke(obj, new Object[0])) == null) continue;
                        out.writeVarBegin(name);
                        out.writeObject(value);
                        out.writeVarEnd();
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        throw new IOException("Error reading property " + cls.getName() + "." + name + ": " + e.getTargetException().getMessage());
                    }
                }
                out.writeStructEnd();
            }
            catch (IntrospectionException e) {
                throw new IOException("IntrospectionException: " + cls.getName());
            }
        }
    }

    static String getTypeSignature(Class cls) {
        StringBuffer sig = new StringBuffer();
        if (cls.isArray()) {
            return cls.getName();
        }
        if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                sig.append('I');
            } else if (cls == Byte.TYPE) {
                sig.append('B');
            } else if (cls == Long.TYPE) {
                sig.append('J');
            } else if (cls == Float.TYPE) {
                sig.append('F');
            } else if (cls == Double.TYPE) {
                sig.append('D');
            } else if (cls == Short.TYPE) {
                sig.append('S');
            } else if (cls == Character.TYPE) {
                sig.append('C');
            } else if (cls == Boolean.TYPE) {
                sig.append('Z');
            }
        } else {
            sig.append('L');
            sig.append(cls.getName());
            sig.append(';');
        }
        return sig.toString();
    }
}

