/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.DeserializationContext;
import com.allaire.wddx.ElementFactory;
import com.allaire.wddx.ElementFactoryMgr;
import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import com.allaire.wddx.WddxParseException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DeserializerWorker
extends HandlerBase
implements DeserializationContext {
    private static final String ROOT_ELEMENT_NAME = "wddxPacket";
    private static final String VERSION_ATTRIBUTE_NAME = "version";
    private static ElementFactoryMgr m_elementFactoryMgr = null;
    private ElementFactory m_elementFactory = null;
    private Vector m_stackElements = new Vector();
    private Parser m_parser = null;
    private Locator m_locator = null;
    private Object m_result = null;
    private CharArrayWriter characters;

    private DeserializerWorker() {
    }

    DeserializerWorker(String parserClass) throws WddxDeserializationException {
        this.createElementFactoryMgr();
        try {
            Class<?> saxParserClass = Class.forName(parserClass);
            this.m_parser = (Parser)saxParserClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            this.throwException("Cannot find SAX parser class " + parserClass, e);
        }
        catch (ClassCastException e) {
            this.throwException("Parser class " + parserClass + " does not implement org.xml.sax.Parser interface", e);
        }
        catch (IllegalAccessException e) {
            this.throwException("No permission to load SAX parser class " + parserClass, e);
        }
        catch (InstantiationException e) {
            throw new WddxDeserializationException("Cannot instantiate SAX parser class " + parserClass, e);
        }
        this.m_parser.setDocumentHandler(this);
        this.m_parser.setErrorHandler(this);
    }

    public void startDocument() throws SAXException {
        this.characters = new CharArrayWriter();
    }

    public void endDocument() throws SAXException {
        this.characters.close();
        this.characters = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public void startElement(String name, AttributeList atts) throws SAXException {
        this.characters.reset();
        try {
            if (this.m_stackElements.isEmpty()) {
                if (!name.equals(ROOT_ELEMENT_NAME) || atts.getLength() != 1 || !atts.getName(0).equals(VERSION_ATTRIBUTE_NAME)) {
                    this.throwSAXException("Invalid WDDX packet: root element in not wddxPacket");
                }
                this.m_elementFactory = m_elementFactoryMgr.getElementFactory(atts.getValue(0));
            }
            if (!this.m_stackElements.isEmpty()) {
                this.getTopElement().onBeforeChild(name, atts);
            }
            WddxElement currentElement = this.m_elementFactory.makeWddxElement(name);
            currentElement.setDeserializationContext(this);
            currentElement.onStartElement(name, atts);
            this.pushElement(currentElement);
        }
        catch (WddxDeserializationException e) {
            this.throwSAXException(e);
        }
    }

    public void endElement(String name) throws SAXException {
        char[] chars = this.characters.toCharArray();
        try {
            this.getTopElement().onCharacters(chars, 0, chars.length);
        }
        catch (WddxDeserializationException e) {
            this.throwSAXException(e);
        }
        try {
            WddxElement currentElement = this.popElement();
            currentElement.onEndElement();
            if (!this.m_stackElements.isEmpty()) {
                this.getTopElement().onAfterChild(currentElement);
            } else {
                this.m_result = currentElement.getValue();
            }
        }
        catch (WddxDeserializationException e) {
            this.throwSAXException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.write(ch, start, length);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.throwSAXException(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.throwSAXException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object deserialize(InputSource source) throws WddxDeserializationException, IOException {
        Object result = null;
        try {
            try {
                this.m_parser.parse(source);
            }
            catch (SAXException e) {
                this.throwException(e);
            }
            result = this.m_result;
        }
        finally {
            this.m_stackElements.setSize(0);
            this.m_result = null;
            this.m_locator = null;
            this.m_elementFactory = null;
        }
        return result;
    }

    public WddxElement getParentElement() throws WddxDeserializationException {
        return this.getTopElement();
    }

    private WddxElement getTopElement() throws WddxDeserializationException {
        WddxElement topElement = null;
        try {
            topElement = (WddxElement)this.m_stackElements.lastElement();
        }
        catch (NoSuchElementException e) {
            this.throwException("Attempting to access empty element stack", e);
        }
        catch (ClassCastException e) {
            this.throwException("Invalid element on stack", e);
        }
        return topElement;
    }

    private void pushElement(WddxElement element) {
        this.m_stackElements.addElement(element);
    }

    private WddxElement popElement() throws WddxDeserializationException {
        WddxElement topElement = this.getTopElement();
        this.m_stackElements.setSize(this.m_stackElements.size() - 1);
        return topElement;
    }

    private synchronized void createElementFactoryMgr() throws WddxDeserializationException {
        if (m_elementFactoryMgr == null) {
            m_elementFactoryMgr = new ElementFactoryMgr();
        }
    }

    private WddxDeserializationException createWddxDeserializationException(String message, Exception e) {
        WddxDeserializationException wddxSerializationException = this.m_locator != null ? new WddxParseException(message, this.m_locator.getPublicId(), this.m_locator.getSystemId(), this.m_locator.getLineNumber(), this.m_locator.getColumnNumber(), e) : new WddxDeserializationException(message, e);
        return wddxSerializationException;
    }

    private void throwSAXException(String message) throws SAXException {
        this.throwSAXException(message, null);
    }

    private void throwSAXException(String message, Exception e) throws SAXException {
        this.throwSAXException(this.createWddxDeserializationException(message, e));
    }

    private void throwSAXException(SAXParseException e) throws SAXException {
        WddxParseException wddxDeserializationException = new WddxParseException(e.getMessage(), e.getPublicId(), e.getSystemId(), e.getLineNumber(), e.getColumnNumber(), e);
        this.throwSAXException(wddxDeserializationException);
    }

    private void throwSAXException(WddxDeserializationException e) throws SAXException {
        throw new SAXException(e);
    }

    private void throwException(String message, Exception e) throws WddxDeserializationException {
        throw this.createWddxDeserializationException(message, e);
    }

    private void throwException(SAXException e) throws WddxDeserializationException {
        Exception heldException = e.getException();
        if (heldException != null) {
            try {
                WddxDeserializationException wddxDeserializationException = (WddxDeserializationException)heldException;
                throw wddxDeserializationException;
            }
            catch (ClassCastException eTemp) {
                throw new WddxDeserializationException(e.getMessage(), heldException);
            }
        }
        throw new WddxDeserializationException(e.getMessage());
    }
}

