/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.ElementFactory;
import com.allaire.wddx.WddxDefaults;
import com.allaire.wddx.WddxDeserializationException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ElementFactoryMgr {
    private Hashtable m_elementFactories = new Hashtable();
    private ElementFactory m_defaultFactory;

    ElementFactoryMgr() throws WddxDeserializationException {
        this(WddxDefaults.getProperties());
    }

    ElementFactoryMgr(Properties config) throws WddxDeserializationException {
        try {
            ElementFactory ef = new ElementFactory();
            Enumeration<?> propNames = config.propertyNames();
            while (propNames.hasMoreElements()) {
                String pName = (String)propNames.nextElement();
                if (!pName.startsWith("deserializer.")) continue;
                String elementName = pName.substring("deserializer.".length());
                String handlerClassname = config.getProperty(pName);
                ef.registerWddxElement(elementName, handlerClassname);
            }
            this.m_elementFactories.put(new Float("0.9"), ef);
            this.m_elementFactories.put(new Float("1.0"), ef);
            this.m_defaultFactory = ef;
        }
        catch (NullPointerException e) {
            throw new WddxDeserializationException("Null pointer exception upon instantiating and loading WDDX element factories", e);
        }
    }

    public ElementFactory getElementFactory(String version) throws WddxDeserializationException {
        try {
            ElementFactory ef = (ElementFactory)this.m_elementFactories.get(new Float(version));
            if (ef == null) {
                ef = this.m_defaultFactory;
            }
            return ef;
        }
        catch (NullPointerException e) {
            throw new WddxDeserializationException("Null pointer exception WDDX version", e);
        }
        catch (ClassCastException e) {
            throw new WddxDeserializationException("Invalid cast exception for WDDX version " + version, e);
        }
    }
}

