/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.util.DuplicateColumnNameException;
import com.allaire.util.NegativeRowNumberException;
import com.allaire.util.RowSizeMismatchException;
import com.allaire.util.SimpleRecordSet;
import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import java.util.Vector;
import org.xml.sax.AttributeList;

class RecordsetHandler
extends WddxElement {
    private static final String ROWCOUNT_ATTRIBUTE_NAME = "rowCount";
    private static final String FIELDNAMES_ATTRIBUTE_NAME = "fieldNames";
    private static final String FIELD_ELEMENT_NAME = "field";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private SimpleRecordSet m_rs = null;
    private String m_currentFieldName = null;

    RecordsetHandler() {
    }

    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        String fieldNames;
        String rowCount = attributes.getValue(ROWCOUNT_ATTRIBUTE_NAME);
        if (rowCount == null) {
            this.throwException("recordset element does not have a rowCount attribute.");
        }
        if ((fieldNames = attributes.getValue(FIELDNAMES_ATTRIBUTE_NAME)) == null) {
            this.throwException("recordset element does not have a fieldNames attribute.");
        }
        try {
            this.m_rs = new SimpleRecordSet(Integer.parseInt(rowCount));
        }
        catch (NumberFormatException e) {
            this.throwException("The rowCount attribute is not an integer", e);
        }
        catch (NegativeRowNumberException e) {
            this.throwException("The rowCount attribute has a negative value", e);
        }
    }

    public void onEndElement() throws WddxDeserializationException {
        this.setValue(this.m_rs);
    }

    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        if (!name.equals(FIELD_ELEMENT_NAME)) {
            this.throwException("Only field elements can be nested inside a recordset element");
        }
        this.m_currentFieldName = attributes.getValue(NAME_ATTRIBUTE_NAME);
        if (this.m_currentFieldName == null) {
            this.throwException("field element does not have a name attribute.");
        }
    }

    public void onAfterChild(WddxElement childElement) throws WddxDeserializationException {
        try {
            this.m_rs.addColumn(this.m_currentFieldName, (Vector)childElement.getValue());
        }
        catch (ClassCastException e) {
            throw new WddxDeserializationException("Invalid cast exception for field element result type", e);
        }
        catch (DuplicateColumnNameException e) {
            throw new WddxDeserializationException("Duplicate field name " + this.m_currentFieldName, e);
        }
        catch (RowSizeMismatchException e) {
            throw new WddxDeserializationException("Invalid number of rows in field. There must be " + new Integer(this.m_rs.getRowCount()).toString() + " rows", e);
        }
    }
}

