/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import org.xml.sax.AttributeList;

class StringHandler
extends WddxElement {
    private static final String CHAR_ELEMENT_NAME = "char";
    private static final String CODE_ATTRIBUTE_NAME = "code";
    private StringBuffer m_buffer = new StringBuffer();

    StringHandler() {
    }

    public void onEndElement() throws WddxDeserializationException {
        String unescapedChars = this.unescapeSpecialChars(this.m_buffer.toString());
        this.setValue(unescapedChars);
    }

    private String unescapeSpecialChars(String inputString) {
        StringBuffer resultString = new StringBuffer(inputString.length() + 10);
        for (int i = 0; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            if (c == '&') {
                int nextSemi = inputString.indexOf(59, i + 1);
                if (nextSemi < 0) {
                    resultString.append(inputString.substring(i));
                    continue;
                }
                String entity = inputString.substring(i + 1, nextSemi);
                if ("lt".equals(entity)) {
                    resultString.append('<');
                } else if ("gt".equals(entity)) {
                    resultString.append('>');
                } else if ("amp".equals(entity)) {
                    resultString.append('&');
                } else if (entity != null && entity.length() > 2 && entity.charAt(0) == '#') {
                    this.appendUnicode(resultString, entity);
                } else {
                    this.appendEntity(resultString, entity);
                }
                i = nextSemi;
                continue;
            }
            resultString.append(c);
        }
        return resultString.toString();
    }

    private void appendUnicode(StringBuffer resultString, String entity) {
        try {
            int ord;
            switch (entity.charAt(1)) {
                case 'x': {
                    ord = Integer.parseInt(entity.substring(2), 16);
                    break;
                }
                case 'u': {
                    ord = Integer.parseInt(entity.substring(2), 8);
                    break;
                }
                default: {
                    ord = Integer.parseInt(entity.substring(1), 10);
                }
            }
            resultString.append((char)ord);
        }
        catch (NumberFormatException e) {
            this.appendEntity(resultString, entity);
        }
    }

    private void appendEntity(StringBuffer resultString, String entity) {
        resultString.append('&');
        resultString.append(entity);
        resultString.append(';');
    }

    public void onCharacters(char[] ch, int start, int length) throws WddxDeserializationException {
        this.m_buffer.append(ch, start, length);
    }

    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        String code;
        if (!name.equals(CHAR_ELEMENT_NAME)) {
            this.throwException("Invalid element " + name + " inside a string element");
        }
        if ((code = attributes.getValue(CODE_ATTRIBUTE_NAME)) == null) {
            this.throwException("code attribute is not present for element char");
        }
        try {
            this.m_buffer.append((char)Integer.parseInt(code, 16));
        }
        catch (NumberFormatException e) {
            this.throwException("Bad character code in char element code= attribute.", e);
        }
    }
}

