/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.util.ObjectConversionException;
import com.allaire.util.ObjectConverter;
import com.allaire.wddx.WddxDeserializationException;
import com.allaire.wddx.WddxElement;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.AttributeList;

class StructHandler
extends WddxElement {
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String VAR_ELEMENT_NAME = "var";
    private Hashtable m_ht = new Hashtable();
    private String m_currentVarName = null;
    private String m_strictType = null;

    StructHandler() {
    }

    public void onStartElement(String name, AttributeList attributes) throws WddxDeserializationException {
        this.m_strictType = attributes.getValue(TYPE_ATTRIBUTE_NAME);
        if (this.m_strictType != null) {
            this.m_ht.put("_wddx_structAttributes_type", this.m_strictType);
        }
    }

    public void onEndElement() throws WddxDeserializationException {
        if (this.m_strictType == null) {
            this.setValue(this.m_ht);
        } else {
            try {
                Class beanClass = StructHandler.getClassBySignature(this.m_strictType);
                Object bean = beanClass.newInstance();
                this.setBeanProperties(bean, this.m_ht);
                this.setValue(bean);
            }
            catch (InstantiationException e) {
                this.setValue(this.m_ht);
            }
            catch (IllegalAccessException e) {
                this.setValue(this.m_ht);
            }
            catch (ClassNotFoundException e) {
                this.setValue(this.m_ht);
            }
            catch (WddxDeserializationException e) {
                this.setValue(this.m_ht);
            }
        }
    }

    public void onBeforeChild(String name, AttributeList attributes) throws WddxDeserializationException {
        if (!name.equals(VAR_ELEMENT_NAME)) {
            this.throwException("Only var elements can be nested inside a struct element");
        }
        this.m_currentVarName = attributes.getValue(NAME_ATTRIBUTE_NAME);
        if (this.m_currentVarName == null) {
            this.throwException("name attribute not provided for var element");
        }
    }

    public void onAfterChild(WddxElement childElement) throws WddxDeserializationException {
        this.m_ht.put(this.m_currentVarName, childElement.getValue());
    }

    private void setBeanProperties(Object bean, Hashtable props) throws WddxDeserializationException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(bean.getClass(), Object.class);
            PropertyDescriptor[] descriptorArray = beanInfo.getPropertyDescriptors();
            Hashtable<String, PropertyDescriptor> descriptors = new Hashtable<String, PropertyDescriptor>();
            for (int i = 0; i < descriptorArray.length; ++i) {
                descriptors.put(descriptorArray[i].getName(), descriptorArray[i]);
            }
            Enumeration propNames = props.keys();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                Object propValue = props.get(propName);
                PropertyDescriptor pd = (PropertyDescriptor)descriptors.get(propName);
                if (pd == null) continue;
                if (pd instanceof IndexedPropertyDescriptor) {
                    Vector values = (Vector)propValue;
                    IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                    Method method = ipd.getIndexedWriteMethod();
                    if (method == null) continue;
                    try {
                        int size = values.size();
                        for (int index = 0; index < size; ++index) {
                            Object value = values.elementAt(index);
                            Class<?>[] types = method.getParameterTypes();
                            value = ObjectConverter.convert(value, types[1]);
                            method.invoke(bean, new Integer(index), value);
                        }
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        this.throwException(method + " threw an exception", e);
                        continue;
                    }
                    catch (ObjectConversionException e) {
                        this.throwException("Incompatible value type for property: " + pd.getName());
                        continue;
                    }
                }
                Method method = pd.getWriteMethod();
                if (method == null) continue;
                try {
                    Object value = propValue;
                    Class<?>[] types = method.getParameterTypes();
                    value = ObjectConverter.convert(value, types[0]);
                    method.invoke(bean, value);
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    this.throwException(method + " threw an exception", e);
                }
                catch (ObjectConversionException e) {
                    this.throwException("Incompatible value type for property: " + pd.getName());
                }
            }
        }
        catch (IntrospectionException e) {
            this.throwException("Bean introspection failed", e);
        }
    }

    private static Class getClassBySignature(String jniTypeSig) throws ClassNotFoundException {
        int index = 0;
        char c = jniTypeSig.charAt(index);
        switch (c) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            default: {
                String className = jniTypeSig.substring(index + 1, jniTypeSig.length() - 1);
                return Class.forName(className);
            }
            case '[': 
        }
        String className = jniTypeSig.substring(index, jniTypeSig.length());
        return Class.forName(className);
    }
}

