/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.DeserializerWorker;
import com.allaire.wddx.WddxDeserializationException;
import java.io.IOException;
import org.xml.sax.InputSource;

public class WddxDeserializer {
    private static final String DEFAULT_SAX_CLASS_PROPERTY = "org.xml.sax.parser";
    private DeserializerWorker m_worker = null;

    public WddxDeserializer() throws WddxDeserializationException {
        String parserClass = System.getProperty(DEFAULT_SAX_CLASS_PROPERTY);
        if (parserClass == null) {
            String errorMessage = "No value for org.xml.sax.parser property.";
            throw new WddxDeserializationException(errorMessage, new NullPointerException(errorMessage));
        }
        this.constructDeserializationWorker(parserClass);
    }

    public WddxDeserializer(String parserClass) throws WddxDeserializationException {
        this.constructDeserializationWorker(parserClass);
    }

    public Object deserialize(InputSource source) throws WddxDeserializationException, IOException {
        return this.m_worker.deserialize(source);
    }

    private void constructDeserializationWorker(String parserClass) throws WddxDeserializationException {
        this.m_worker = new DeserializerWorker(parserClass);
        if (this.m_worker == null) {
            String errorMessage = "Cannot instantiate WDDX deserializer.";
            throw new WddxDeserializationException(errorMessage, new NullPointerException(errorMessage));
        }
    }
}

