/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.wddx.WddxDefaults;
import com.allaire.wddx.WddxException;
import com.allaire.wddx.WddxObjectSerializer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class WddxObjectSerializerFactory {
    private Hashtable m_serializers = new Hashtable();
    private Vector m_registeredClasses = new Vector();

    public WddxObjectSerializerFactory() {
        try {
            this.init(WddxDefaults.getProperties());
        }
        catch (WddxException e) {
            System.err.println("WDDX Java SDK bug: invalid default properties");
            e.printStackTrace();
        }
    }

    public WddxObjectSerializerFactory(Properties props) throws WddxException {
        this.init(props);
    }

    public synchronized void registerSerializer(String className, WddxObjectSerializer os) {
        try {
            Class<?> cls = Class.forName(className);
            this.m_registeredClasses.addElement(cls);
            this.m_serializers.put(cls.getName(), os);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public synchronized void registerSerializer(Object obj, WddxObjectSerializer os) {
        this.m_registeredClasses.addElement(obj.getClass());
        this.m_serializers.put(obj.getClass().getName(), os);
    }

    public synchronized WddxObjectSerializer getSerializer(String className) {
        WddxObjectSerializer serializer = null;
        Object obj = this.m_serializers.get(className);
        if (obj != null) {
            try {
                serializer = (WddxObjectSerializer)obj;
            }
            catch (ClassCastException e) {
                // empty catch block
            }
        }
        return serializer;
    }

    public synchronized WddxObjectSerializer getSerializer(Object obj) {
        Class<?> objClass = obj.getClass();
        String className = objClass.getName();
        WddxObjectSerializer ser = this.getSerializer(className);
        if (ser != null) {
            return ser;
        }
        Enumeration enumElements = this.m_registeredClasses.elements();
        while (enumElements.hasMoreElements() && ser == null) {
            Class cls = (Class)enumElements.nextElement();
            if (!cls.isAssignableFrom(objClass)) continue;
            ser = this.getSerializer(cls.getName());
        }
        if (ser != null) {
            this.registerSerializer(objClass.getName(), ser);
        }
        return ser;
    }

    private void init(Properties config) throws WddxException {
        String configVal;
        int i = 1;
        while ((configVal = config.getProperty("serializer." + i)) != null) {
            int index = configVal.indexOf("=");
            String type = configVal.substring(0, index);
            String className = configVal.substring(index + 1);
            try {
                WddxObjectSerializer ser = (WddxObjectSerializer)Class.forName(className).newInstance();
                this.registerSerializer(type, ser);
            }
            catch (ClassNotFoundException e) {
                throw new WddxException("Serializer class not found: " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new WddxException("Serializer class not publicly accessible: " + className, e);
            }
            catch (InstantiationException e) {
                throw new WddxException("Serializer class load error: " + className, e);
            }
            ++i;
        }
    }
}

