/*
 * Decompiled with CFR 0.152.
 */
package com.allaire.wddx;

import com.allaire.util.ISO8601;
import com.allaire.util.RecordSet;
import com.allaire.util.RecordSetException;
import com.allaire.util.SpecialCharInfo;
import com.allaire.util.UTF8Converter;
import com.allaire.wddx.WddxObjectSerializer;
import com.allaire.wddx.WddxSerializer;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class WddxOutputStream
extends OutputStream
implements ObjectOutput {
    protected static UTF8Converter m_UTF8Converter = new UTF8Converter();
    protected WddxSerializer m_serializer;
    protected PrintWriter m_out;
    protected SpecialCharInfo[] m_UTF8CharTable;

    WddxOutputStream(WddxSerializer serializer, PrintWriter out) {
        this.m_serializer = serializer;
        this.m_out = out;
        this.m_UTF8CharTable = m_UTF8Converter.getCharInfo();
    }

    public void flush() {
        this.m_out.flush();
    }

    public void close() {
        this.m_out.close();
    }

    void writeUnformattedChars(String s) throws IOException {
        this.m_out.write(s);
    }

    void writeStructBegin() throws IOException {
        this.writeUnformattedChars("<struct>");
    }

    void writeStructBegin(String type) throws IOException {
        this.writeUnformattedChars("<struct type='");
        this.writeUnformattedChars(type);
        this.writeUnformattedChars("'>");
    }

    void writeStructEnd() throws IOException {
        this.writeUnformattedChars("</struct>");
    }

    void writeVarBegin(String name) throws IOException {
        this.writeUnformattedChars("<var name='");
        this.writeUnformattedChars(name);
        this.writeUnformattedChars("'>");
    }

    void writeVarEnd() throws IOException {
        this.writeUnformattedChars("</var>");
    }

    void writeArrayBegin(int length) throws IOException {
        this.writeUnformattedChars("<array length='");
        this.writeUnformattedChars(String.valueOf(length));
        this.writeUnformattedChars("'>");
    }

    void writeArrayEnd() throws IOException {
        this.writeUnformattedChars("</array>");
    }

    void writeRecordSetBegin(int rowCount, String[] fields) throws IOException {
        this.writeUnformattedChars("<recordset rowCount='");
        this.writeUnformattedChars(String.valueOf(rowCount));
        this.writeUnformattedChars("' fieldNames='");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                this.writeUnformattedChars(",");
            }
            this.writeUnformattedChars(fields[i]);
        }
        this.writeUnformattedChars("'>");
    }

    void writeRecordSetEnd() throws IOException {
        this.writeUnformattedChars("</recordset>");
    }

    void writeFieldBegin(String name) throws IOException {
        this.writeUnformattedChars("<field name='");
        this.writeUnformattedChars(name);
        this.writeUnformattedChars("'>");
    }

    void writeFieldEnd() throws IOException {
        this.writeUnformattedChars("</field>");
    }

    public void writeUTF(String str) throws IOException {
        throw new IOException("writeUTF() cannot be called");
    }

    public void writeShort(int v) throws IOException {
        this.writeLong(v);
    }

    public void writeObject(Object obj) throws IOException {
        if (obj != null) {
            WddxObjectSerializer os = this.m_serializer.getSerializerFactory().getSerializer(obj);
            if (os == null) {
                throw new IOException("cannot serialize object type " + obj.toString());
            }
            os.writeObject(this, obj);
        } else {
            this.writeNull();
        }
    }

    public void writeLong(long v) throws IOException {
        this.writeUnformattedChars("<number>");
        this.writeUnformattedChars(String.valueOf(v));
        this.writeUnformattedChars("</number>");
    }

    public void writeInt(int v) throws IOException {
        this.writeLong(v);
    }

    public void writeFloat(float v) throws IOException {
        this.writeDouble(v);
    }

    public void writeDouble(double v) throws IOException {
        this.writeUnformattedChars("<number>");
        this.writeUnformattedChars(String.valueOf(v));
        this.writeUnformattedChars("</number>");
    }

    public void writeChars(String s) throws IOException {
        if (s != null) {
            this.writeUnformattedChars("<string>");
            char[] data = s.toCharArray();
            int beg = 0;
            int end = 0;
            while (data.length > 0) {
                char c;
                boolean isDone;
                do {
                    c = data[end];
                    boolean bl = isDone = ++end >= data.length;
                } while (!isDone && c < '\u0100' && !this.m_UTF8CharTable[c].isSpecialChar);
                if (end > beg + 1) {
                    this.m_out.write(data, beg, end - beg - 1);
                }
                if (c < '\u0100') {
                    char[] outputEncoding = this.m_UTF8CharTable[c].encoding;
                    if (outputEncoding != null) {
                        this.m_out.write(outputEncoding);
                    } else {
                        this.m_out.write(c);
                    }
                } else {
                    this.m_out.write("&#x");
                    this.m_out.write(Integer.toHexString(c));
                    this.m_out.write(";");
                }
                if (isDone) break;
                beg = end;
            }
            this.writeUnformattedChars("</string>");
        } else {
            this.writeNull();
        }
    }

    public void writeChar(int v) throws IOException {
        throw new IOException("writeChar() cannot be called");
    }

    public void writeBytes(String s) throws IOException {
        throw new IOException("writeBytes() cannot be called");
    }

    public void writeByte(int v) throws IOException {
        this.writeLong(v);
    }

    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.writeUnformattedChars("<boolean value='true'/>");
        } else {
            this.writeUnformattedChars("<boolean value='false'/>");
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        throw new IOException("write(byte b[], int off, int len) cannot be called");
    }

    public void write(byte[] b) throws IOException {
        throw new IOException("write(byte b[]) cannot be called");
    }

    public void write(int b) throws IOException {
        throw new IOException("write(int b) cannot be called");
    }

    public void writeDictionary(Dictionary d) throws IOException {
        if (d != null) {
            String type = (String)d.get("_wddx_structAttributes_type");
            if (type == null) {
                this.writeStructBegin();
            } else {
                this.writeStructBegin(type);
            }
            Enumeration keys = d.keys();
            Enumeration values = d.elements();
            while (keys.hasMoreElements() && values.hasMoreElements()) {
                try {
                    Object value = values.nextElement();
                    String name = keys.nextElement().toString();
                    if (value == type) continue;
                    this.writeVarBegin(name);
                    this.writeObject(value);
                    this.writeVarEnd();
                }
                catch (NoSuchElementException e) {
                    throw new IOException("Mismatched enumerations");
                }
            }
            this.writeStructEnd();
        } else {
            this.writeNull();
        }
    }

    public void writeRecordSet(RecordSet rs) throws IOException {
        if (rs != null) {
            int rowCount = rs.getRowCount();
            int columnCount = rs.getColumnCount();
            String[] columnNames = rs.getColumnNames();
            try {
                this.writeRecordSetBegin(rowCount, columnNames);
                for (int column = 0; column < columnCount; ++column) {
                    this.writeFieldBegin(columnNames[column]);
                    for (int row = 0; row < rowCount; ++row) {
                        this.writeObject(rs.getField(row, column));
                    }
                    this.writeFieldEnd();
                }
                this.writeRecordSetEnd();
            }
            catch (RecordSetException e) {
                throw new IOException("Recordset exception");
            }
        } else {
            this.writeNull();
        }
    }

    public void writeObjectArray(Object[] values, int start, int length) throws IOException {
        this.writeArrayBegin(length);
        for (int i = start; i < start + length; ++i) {
            this.writeObject(values[i]);
        }
        this.writeArrayEnd();
    }

    public void writeObjectArray(Object[] values) throws IOException {
        this.writeObjectArray(values, 0, values.length);
    }

    public void writeVector(Vector v) throws IOException {
        if (v != null) {
            this.writeArrayBegin(v.size());
            for (int i = 0; i < v.size(); ++i) {
                this.writeObject(v.elementAt(i));
            }
            this.writeArrayEnd();
        } else {
            this.writeNull();
        }
    }

    public void writeDate(Date d) throws IOException {
        if (d != null) {
            this.writeUnformattedChars("<dateTime>");
            this.writeUnformattedChars(ISO8601.stringValueOf(d, true));
            this.writeUnformattedChars("</dateTime>");
        } else {
            this.writeNull();
        }
    }

    public void writeNull() throws IOException {
        this.writeUnformattedChars("<null/>");
    }
}

