/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit.parsing;

import com.meterware.httpunit.parsing.NekoDOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.filters.DefaultFilter;

class ScriptFilter
extends DefaultFilter {
    private HTMLConfiguration _configuration;
    private StringBuffer _activeScriptBlock;
    private String _scriptLanguage;
    private String _systemID = "";
    private int _scriptIndex;
    private NekoDOMParser _domParser;

    ScriptFilter(HTMLConfiguration config) {
        this._configuration = config;
    }

    public void setParser(NekoDOMParser domParser) {
        this._domParser = domParser;
    }

    public void startDocument(XMLLocator locator, String encoding, Augmentations augs) throws XNIException {
        this._activeScriptBlock = null;
        this._systemID = locator == null ? "" : locator.getLiteralSystemId() + "_";
        this._scriptIndex = 0;
        super.startDocument(locator, encoding, augs);
    }

    public void startElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (!this.isSupportedScript(element, attrs)) {
            super.startElement(element, attrs, augs);
        } else {
            this._activeScriptBlock = new StringBuffer();
            this._scriptLanguage = this.getScriptLanguage(attrs);
            String srcAttribute = attrs.getValue("src");
            if (srcAttribute != null) {
                this._activeScriptBlock.append(this._domParser.getIncludedScript(srcAttribute));
            }
        }
    }

    private boolean isSupportedScript(QName element, XMLAttributes attrs) {
        if (!element.rawname.equalsIgnoreCase("script") || attrs == null) {
            return false;
        }
        String value = this.getScriptLanguage(attrs);
        return this._domParser.getScriptableDelegate().supportsScript(value);
    }

    private String getScriptLanguage(XMLAttributes attrs) {
        return attrs == null ? null : attrs.getValue("language");
    }

    public void emptyElement(QName element, XMLAttributes attrs, Augmentations augs) throws XNIException {
        if (!this.isSupportedScript(element, attrs)) {
            super.emptyElement(element, attrs, augs);
        }
    }

    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (this._activeScriptBlock != null) {
            this._activeScriptBlock.append(text.ch, text.offset, text.length);
        } else {
            super.characters(text, augs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (this._activeScriptBlock == null) {
            super.endElement(element, augs);
        } else {
            try {
                try {
                    String scriptText = this._activeScriptBlock.toString();
                    String replacementText = this.getTranslatedScript(this._scriptLanguage, scriptText);
                    this._configuration.pushInputSource(this.newInputSource(replacementText));
                }
                catch (IOException e) {
                    Object var6_7 = null;
                    this._activeScriptBlock = null;
                }
                Object var6_6 = null;
                this._activeScriptBlock = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this._activeScriptBlock = null;
                throw throwable;
            }
        }
    }

    private XMLInputSource newInputSource(String replacementText) {
        StringBuffer systemID = new StringBuffer(this._systemID);
        systemID.append("script").append(++this._scriptIndex);
        return new XMLInputSource(null, systemID.toString(), null, (Reader)new StringReader(replacementText), "UTF-8");
    }

    protected String getTranslatedScript(String language, String scriptText) throws IOException {
        this._domParser.getScriptableDelegate().getScriptEngine().clearCaches();
        return this._domParser.getScriptableDelegate().runScript(language, scriptText);
    }
}

