/*
 * Decompiled with CFR 0.152.
 */
package middlegen.plugins.hibernate;

import middlegen.Column;
import middlegen.Util;
import middlegen.javax.JavaColumn;
import middlegen.javax.Sql2Java;
import middlegen.plugins.hibernate.HibernatePlugin;
import middlegen.plugins.hibernate.interfaces.JavaTypeMapper;
import middlegen.util.BooleanNode;

public class HibernateColumn
extends JavaColumn {
    private BooleanNode _updateable = BooleanNode.createRoot((boolean)true);
    private BooleanNode _insertable = BooleanNode.createRoot((boolean)true);
    private BooleanNode _incToString = BooleanNode.createRoot((boolean)false);
    private BooleanNode _genProperty = BooleanNode.createRoot((boolean)true);
    private BooleanNode _incEquals = BooleanNode.createRoot((boolean)false);
    private String _getScope;
    private String _setScope;
    private String _fieldScope;
    private String _accessField;
    private String _fieldDescription;
    private String _beanPropertyType;
    private String _columnSpecialty;

    public HibernateColumn(Column subject) {
        super(subject);
    }

    public void setUpdateable(boolean flag) {
        this.setPrefsValue("updateable", Util.string((boolean)flag));
        this._updateable.setValue(flag);
    }

    public void setInsertable(boolean flag) {
        this.setPrefsValue("insertable", Util.string((boolean)flag));
        this._insertable.setValue(flag);
    }

    public void setIncludeToString(boolean flag) {
        this.setPrefsValue("inctostring", Util.string((boolean)flag));
        this._incToString.setValue(flag);
    }

    public void setIncludeEquals(boolean flag) {
        this.setPrefsValue("incequals", Util.string((boolean)flag));
        this._incEquals.setValue(flag);
    }

    public void setGenProperty(boolean flag) {
        this.setPrefsValue("genproperty", Util.string((boolean)flag));
        this._genProperty.setValue(flag);
    }

    public void setFieldGetScope(String value) {
        this.setPrefsValue("getscope", value);
        this._getScope = value;
    }

    public void setFieldSetScope(String value) {
        this.setPrefsValue("setscope", value);
        this._setScope = value;
    }

    public void setFieldScope(String value) {
        this.setPrefsValue("fieldscope", value);
        this._fieldScope = value;
    }

    public void setAccessField(String value) {
        this.setPrefsValue("accessfield", value);
        this._accessField = value;
    }

    public void setFieldDescription(String value) {
        this.setPrefsValue("description", value);
        this._fieldDescription = value;
    }

    public void setColumnSpecialty(String value) {
        this.setPrefsValue("columnspecialty", value);
        this._columnSpecialty = value;
    }

    public void setBeanPropertyType(String value) {
        this.setPrefsValue("beanpropertytype", value);
        this._beanPropertyType = value;
    }

    public boolean isUpdateable() {
        return this._updateable.isCompletelyTrue();
    }

    public boolean isInsertable() {
        return this._insertable.isCompletelyTrue();
    }

    public boolean isIncludeToString() {
        return this._incToString.isCompletelyTrue();
    }

    public boolean isIncludeEquals() {
        return this._incEquals.isCompletelyTrue();
    }

    public boolean isGenProperty() {
        return this._genProperty.isCompletelyTrue();
    }

    public BooleanNode getUpdateableNode() {
        return this._updateable;
    }

    public BooleanNode getInsertableNode() {
        return this._insertable;
    }

    public BooleanNode getIncludeToStringNode() {
        return this._incToString;
    }

    public BooleanNode getIncludeEqualsNode() {
        return this._incEquals;
    }

    public BooleanNode getGenPropertyNode() {
        return this._genProperty;
    }

    public String getFieldScope() {
        return this._fieldScope.trim();
    }

    public String getAccessField() {
        return this._accessField.trim();
    }

    public String getFieldGetScope() {
        return this._getScope.trim();
    }

    public String getFieldSetScope() {
        return this._setScope.trim();
    }

    public String getFieldDescription() {
        return this._fieldDescription.trim();
    }

    public String getBeanPropertyType() {
        return this._beanPropertyType.trim();
    }

    public String getColumnSpecialty() {
        return this._columnSpecialty.trim();
    }

    public String getParseMethod() {
        if (this.isPrimitive()) {
            return this.getClassForPrimitive() + ".parse" + Util.capitalise((String)this.getJavaType());
        }
        if ("java.lang.String".equals(this.getJavaType())) {
            return "";
        }
        return "new " + this.getJavaType();
    }

    public boolean isSized() {
        return super.getSize() != 0;
    }

    public boolean isSpecialtyProperty() {
        return this._columnSpecialty.equals("property");
    }

    public boolean isSpecialtyVersionProperty() {
        return this._columnSpecialty.equals("version");
    }

    public boolean isSpecialtyTimestampProperty() {
        return this._columnSpecialty.equals("timestamp");
    }

    public boolean isMetaData() {
        return this.isIncludeToString() || this.isIncludeEquals() || this.isFieldScopeName() || this.isFieldGetScopeName() || this.isFieldSetScopeName() || this.isFieldDescriptionName() || this.isBeanPropertyTypeName() || !this.isGenProperty();
    }

    public boolean isAccessFieldName() {
        return this._accessField != null && this._accessField.trim().length() != 0 && !this._accessField.equals("property");
    }

    public boolean isFieldScopeName() {
        return this._fieldScope != null && this._fieldScope.trim().length() != 0 && !this._fieldScope.equals("private");
    }

    public boolean isFieldGetScopeName() {
        return this._getScope != null && this._getScope.trim().length() != 0 && !this._getScope.equals("public");
    }

    public boolean isFieldSetScopeName() {
        return this._setScope != null && this._setScope.trim().length() != 0 && !this._setScope.equals("public");
    }

    public boolean isFieldDescriptionName() {
        return this._fieldDescription != null && this._fieldDescription.trim().length() != 0;
    }

    public boolean isBeanPropertyTypeName() {
        return this._beanPropertyType != null && !this._beanPropertyType.equals("unbound");
    }

    public JavaTypeMapper getJavaTypeMapper() {
        return ((HibernatePlugin)this.getPlugin()).getJavaTypeMapper();
    }

    protected void setJavaType() {
        if (this.getPrefsValue("java-type") != null) {
            this.setJavaType(this.getPrefsValue("java-type"));
        } else {
            JavaTypeMapper javaTypeMapper = this.getJavaTypeMapper();
            if (javaTypeMapper == null) {
                this.setJavaType(Sql2Java.getPreferredJavaType((int)this.getSqlType(), (int)this.getSize(), (int)this.getDecimalDigits()));
            } else {
                this.setJavaType(javaTypeMapper.getPreferredJavaType(this));
            }
        }
    }

    protected void init() {
        super.init();
        HibernatePlugin plugin = (HibernatePlugin)this.getPlugin();
        this._updateable.setValue(plugin.isColumnsUpdateable());
        if (this.getPrefsValue("updateable") != null) {
            this.setUpdateable(Util.bool((String)this.getPrefsValue("updateable")));
        }
        this._insertable.setValue(plugin.isColumnsInsertable());
        if (this.getPrefsValue("insertable") != null) {
            this.setInsertable(Util.bool((String)this.getPrefsValue("insertable")));
        }
        this._incEquals.setValue(plugin.isColumnsIncludeEquals());
        if (this.getPrefsValue("incequals") != null) {
            this.setIncludeEquals(Util.bool((String)this.getPrefsValue("incequals")));
        }
        this._incToString.setValue(plugin.isColumnsIncludeToString());
        if (this.getPrefsValue("inctostring") != null) {
            this.setIncludeToString(Util.bool((String)this.getPrefsValue("inctostring")));
        }
        this._genProperty.setValue(plugin.isColumnsGenProperty());
        if (this.getPrefsValue("genproperty") != null) {
            this.setGenProperty(Util.bool((String)this.getPrefsValue("genproperty")));
        }
        this._accessField = plugin.getAccessField();
        if (this.getPrefsValue("accessfield") != null) {
            this.setAccessField(this.getPrefsValue("accessfield"));
        }
        this._fieldScope = plugin.getFieldScope();
        if (this.getPrefsValue("fieldscope") != null) {
            this.setFieldScope(this.getPrefsValue("fieldscope"));
        }
        this._getScope = plugin.getFieldGetScope();
        if (this.getPrefsValue("getscope") != null) {
            this.setFieldGetScope(this.getPrefsValue("getscope"));
        }
        this._setScope = plugin.getFieldSetScope();
        if (this.getPrefsValue("setscope") != null) {
            this.setFieldSetScope(this.getPrefsValue("setscope"));
        }
        this._fieldDescription = plugin.getFieldDescription();
        if (this.getPrefsValue("description") != null) {
            this.setFieldDescription(this.getPrefsValue("description"));
        }
        this._beanPropertyType = plugin.getBeanPropertyType();
        if (this.getPrefsValue("beanpropertytype") != null) {
            this.setBeanPropertyType(this.getPrefsValue("beanpropertytype"));
        }
        this._columnSpecialty = "property";
        if (this.getPrefsValue("columnspecialty") != null) {
            this.setColumnSpecialty(this.getPrefsValue("columnspecialty"));
        }
    }
}

